package name.remal.gradle_plugins.plugins.ci

import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.CreateExtensionsPluginAction
import name.remal.gradle_plugins.dsl.Plugin
import name.remal.gradle_plugins.dsl.PluginAction
import org.gradle.StartParameter
import org.gradle.api.logging.configuration.ShowStacktrace.ALWAYS
import org.gradle.api.logging.configuration.ShowStacktrace.INTERNAL_EXCEPTIONS
import org.gradle.api.plugins.ExtensionContainer

@Plugin(
    id = "name.remal.common-ci",
    description = "Plugin that helps to build project on CI servers.",
    tags = ["ci"]
)
class CommonCIPlugin : BaseReflectiveProjectPlugin() {

    @PluginAction(order = Int.MAX_VALUE)
    fun StartParameter.`Show Gradle stacktrace`() {
        if (showStacktrace == INTERNAL_EXCEPTIONS) {
            showStacktrace = ALWAYS
        }
    }

    @CreateExtensionsPluginAction
    fun ExtensionContainer.`Create 'ci' extension`() {
        create("ci", CIExtension::class.java)
    }

}
