package name.remal.gradle_plugins.plugins.code_quality.findbugs.reporter

import name.remal.default

internal data class FindBugsMessage(
    val priority: Int?,
    val rank: Int?,
    val category: String?,
    val categoryDescription: String?,
    val type: String?,
    val className: String?,
    val classFileName: String?,
    val line: Int?,
    val description: String,
    val detailText: String,
    val detailHtml: String
) : Comparable<FindBugsMessage> {

    override fun compareTo(other: FindBugsMessage): Int {
        (priority ?: Int.MAX_VALUE).compareTo(other.priority ?: Int.MAX_VALUE).let { if (it != 0) return it }
        (rank ?: Int.MAX_VALUE).compareTo(other.rank ?: Int.MAX_VALUE).let { if (it != 0) return it }
        className.default().compareTo(other.className.default()).let { if (it != 0) return it }
        (line ?: Int.MAX_VALUE).compareTo(other.line ?: Int.MAX_VALUE).let { if (it != 0) return it }
        category.default().compareTo(other.category.default()).let { if (it != 0) return it }
        type.default().compareTo(other.type.default()).let { if (it != 0) return it }
        return 0
    }

}
