package name.remal.gradle_plugins.plugins.code_quality.sonar

import groovy.lang.Closure
import groovy.lang.Closure.DELEGATE_FIRST
import groovy.lang.DelegatesTo
import name.remal.gradle_plugins.dsl.Extension
import name.remal.gradle_plugins.dsl.extensions.toConfigureAction
import name.remal.gradle_plugins.plugins.code_quality.ExcludesExtension
import org.gradle.api.Action
import org.gradle.api.plugins.quality.CodeQualityExtension

@Extension
class SonarLintExtension
    : CodeQualityExtension(),
    SonarPropertiesMixin<SonarLintExtension> {

    val excludes: ExcludesExtension = ExcludesExtension()

    fun excludes(configurer: Action<ExcludesExtension>) = apply { configurer.execute(excludes) }

    fun excludes(@DelegatesTo(ExcludesExtension::class, strategy = DELEGATE_FIRST) configurer: Closure<*>) = excludes(configurer.toConfigureAction())

    override var sonarProperties: MutableMap<String, String?> = sortedMapOf()
        set(value) {
            field = value.toSortedMap()
        }

}
