package name.remal.gradle_plugins.plugins.code_quality.sonar

import name.remal.gradle_plugins.dsl.extensions.unwrapProviders
import name.remal.uncheckedCast

interface SonarPropertiesMixin<Chain : SonarPropertiesMixin<Chain>> {

    var sonarProperties: MutableMap<String, String?>

    fun sonarProperty(name: Any?, value: Any?): Chain {
        val stringName = name.unwrapProviders()?.toString()
        if (stringName != null) {
            val stringValue = value.unwrapProviders()?.toString()
            sonarProperties[stringName] = stringValue
        }
        return this.uncheckedCast()
    }

    fun sonarProperties(map: Map<Any?, Any?>): Chain {
        map.forEach { name, value -> sonarProperty(name, value) }
        return this.uncheckedCast()
    }

}
