package name.remal.gradle_plugins.plugins.code_quality.sonar.internal

import org.jdom2.Element

internal data class SonarAnalysisResult(
    val scannedFileCount: Int = 0,
    val failedAnalysisFiles: List<SonarSourceFile> = emptyList(),
    val definedSourceFileLanguages: List<SonarSourceFileLanguage> = emptyList(),
    val issues: List<SonarIssue> = emptyList()
) : WithToXmlElement {

    override fun fillXmlElement(element: Element) {
        element.apply {
            addContent(newXmlElement(SonarAnalysisResult::scannedFileCount).setText(scannedFileCount.toString()))
            if (failedAnalysisFiles.isNotEmpty()) {
                addContent(newXmlElement(SonarAnalysisResult::failedAnalysisFiles) {
                    failedAnalysisFiles.forEach {
                        addContent(newXmlElement("file") {
                            attr(it::absolutePath)
                            attr(it::relativePath)
                        })
                    }
                })
            }
            if (issues.isNotEmpty()) {
                addContent(newXmlElement(SonarAnalysisResult::issues) {
                    issues.forEach { addContent(it.toXmlElement()) }
                })
            }
            if (definedSourceFileLanguages.isNotEmpty()) {
                addContent(newXmlElement(SonarAnalysisResult::definedSourceFileLanguages) {
                    definedSourceFileLanguages.forEach { addContent(it.toXmlElement()) }
                })
            }
        }
    }

}
