package name.remal.gradle_plugins.plugins.code_quality.sonar.internal

import org.jdom2.Element

internal data class SonarFlow(
    val locations: List<SonarSourceLocation> = emptyList()
) : WithToXmlElement {

    override fun fillXmlElement(element: Element) {
        element.apply {
            if (locations.isNotEmpty()) {
                addContent(newXmlElement(this@SonarFlow::locations) {
                    locations.forEach { location ->
                        addContent(location.toXmlElement())
                    }
                })
            }
        }
    }

}
