package name.remal.gradle_plugins.plugins.code_quality.sonar.internal

import name.remal.default
import name.remal.gradle_plugins.dsl.utils.htmlToText
import org.jdom2.Element

internal data class SonarIssue(
    val location: SonarSourceLocation,
    val ruleKey: String,
    val severity: String,
    val type: String? = null,
    val description: String,
    val detailHtml: String?,
    val detailText: String? = detailHtml?.let { htmlToText(it) },
    val flows: List<SonarFlow> = emptyList()
) : Comparable<SonarIssue>, WithToXmlElement {

    companion object {
        private val SORTED_SEVERITIES = listOf("INFO", "MINOR", "MAJOR", "CRITICAL", "BLOCKER")
    }

    private val priority: Int = SORTED_SEVERITIES.indexOf(severity.toUpperCase())

    override fun compareTo(other: SonarIssue): Int {
        priority.compareTo(other.priority).let { if (it != 0) return -1 * it }
        location.compareTo(other.location).let { if (it != 0) return it }
        type.default().compareTo(other.type.default()).let { if (it != 0) return it }
        ruleKey.compareTo(other.ruleKey).let { if (it != 0) return it }
        return 0
    }

    override fun fillXmlElement(element: Element) {
        element.apply {
            attr(this@SonarIssue::ruleKey)
            attr(this@SonarIssue::severity)
            attr(this@SonarIssue::type)
            addContent(newXmlElement(SonarIssue::location, location))
            addContent(newXmlElement(SonarIssue::description, description))
            addContent(newXmlElement(SonarIssue::detailText) { addContent(newXmlCDATA(detailText)) })
            addContent(newXmlElement(SonarIssue::detailHtml) { addContent(newXmlCDATA(detailHtml)) })
            if (flows.isNotEmpty()) {
                addContent(newXmlElement(SonarIssue::flows) {
                    flows.forEach { flow ->
                        addContent(flow.toXmlElement())
                    }
                })
            }
        }
    }

}
