package name.remal.gradle_plugins.plugins.code_quality.sonar.internal

import name.remal.default
import org.jdom2.Element

internal data class SonarSourceLocation(
    val sourceFile: SonarSourceFile? = null,
    val startLine: Int? = null,
    val startLineOffset: Int? = null,
    val endLine: Int? = null,
    val endLineOffset: Int? = null,
    val message: String? = null
) : Comparable<SonarSourceLocation>, WithToXmlElement {

    val absolutePath = sourceFile?.file?.absolutePath

    override fun compareTo(other: SonarSourceLocation): Int {
        absolutePath.default().compareTo(other.absolutePath.default()).let { if (it != 0) return it }
        (startLine ?: Int.MIN_VALUE).compareTo(other.startLine ?: Int.MIN_VALUE).let { if (it != 0) return it }
        (startLineOffset ?: Int.MIN_VALUE).compareTo(other.startLineOffset ?: Int.MIN_VALUE).let { if (it != 0) return it }
        return 0
    }

    override fun fillXmlElement(element: Element) {
        element.apply {
            sourceFile?.also {
                attr(it::absolutePath)
                attr(it::relativePath)
                attr(it::isTest)
            }
            attr(this@SonarSourceLocation::startLine)
            attr(this@SonarSourceLocation::startLineOffset)
            attr(this@SonarSourceLocation::endLine)
            attr(this@SonarSourceLocation::endLineOffset)
        }
    }

}
