package name.remal.gradle_plugins.plugins.code_quality.sonar.internal

import name.remal.default
import name.remal.fromLowerCamelToLowerHyphen
import name.remal.fromUpperCamelToLowerHyphen
import name.remal.gradle_plugins.dsl.extensions.unwrapProviders
import org.jdom2.CDATA
import org.jdom2.Element
import kotlin.reflect.KProperty
import kotlin.reflect.KProperty0

internal fun newXmlElement(clazz: Class<*>, configurer: Element.() -> Unit = {}) = newXmlElement(clazz, null, configurer)
internal fun newXmlElement(clazz: Class<*>, content: Any?, configurer: Element.() -> Unit = {}) = newXmlElement(clazz.simpleName.fromUpperCamelToLowerHyphen(), content, configurer)
internal fun newXmlElement(property: KProperty<*>, configurer: Element.() -> Unit = {}) = newXmlElement(property, null, configurer)
internal fun newXmlElement(property: KProperty<*>, content: Any?, configurer: Element.() -> Unit = {}) = newXmlElement(property.name.fromLowerCamelToLowerHyphen(), content, configurer)
internal fun newXmlElement(name: String, configurer: Element.() -> Unit = {}) = newXmlElement(name, null, configurer)
internal fun newXmlElement(name: String, content: Any?, configurer: Element.() -> Unit = {}) = Element(name.normalizeName()).apply {
    val unwrappedContent = content.unwrapProviders()
    if (unwrappedContent != null) {
        if (unwrappedContent is WithToXmlElement) {
            unwrappedContent.fillXmlElement(this)
        } else {
            text = unwrappedContent.toString()
        }
    }
}.apply(configurer)


internal fun newXmlCDATA(content: Any?) = CDATA(content.unwrapProviders()?.toString().default())


internal fun Element.attr(property: KProperty<*>, value: Any?) = attr(property.name.fromLowerCamelToLowerHyphen().normalizeName(), value)
internal fun Element.attr(property: KProperty0<*>) = attr(property, property())
internal fun Element.attr(name: Any?, value: Any?) = apply {
    val nameString = name.unwrapProviders()?.toString()
    if (nameString != null) {
        val valueString = value.unwrapProviders()?.toString()
        if (valueString != null) {
            setAttribute(nameString, valueString)
        } else {
            removeAttribute(nameString)
        }
    }
}


private const val NAME_PREFIX = "sonar-"
private fun String.normalizeName(): String {
    if (startsWith(NAME_PREFIX) && length > NAME_PREFIX.length) {
        return substring(NAME_PREFIX.length)
    } else {
        return this
    }
}
