package name.remal.gradle_plugins.plugins.common

import name.remal.gradle_plugins.dsl.*
import name.remal.gradle_plugins.dsl.extensions.*
import name.remal.gradle_plugins.plugins.component_capabilities.ComponentCapabilitiesPlugin
import name.remal.gradle_plugins.plugins.dependencies.DependenciesExtensionsPlugin
import name.remal.gradle_plugins.plugins.ide.eclipse.EclipsePluginId
import name.remal.gradle_plugins.plugins.ide.eclipse.EclipseSettingsPlugin
import name.remal.gradle_plugins.plugins.ide.idea.IdeaPluginId
import name.remal.gradle_plugins.plugins.ide.idea.IdeaSettingsPlugin
import org.gradle.api.Project
import org.gradle.api.artifacts.ConfigurationContainer
import org.gradle.api.artifacts.ModuleDependency
import org.gradle.api.file.CopySpec
import org.gradle.api.file.DuplicatesStrategy.WARN
import org.gradle.api.tasks.TaskContainer
import org.gradle.api.tasks.bundling.AbstractArchiveTask

@Plugin(
    id = "name.remal.common-settings",
    description = "Plugin that applies common settings",
    tags = ["common"]
)
@ApplyPlugins(
    IdeaPluginId::class,
    EclipsePluginId::class
)
@ApplyPluginClasses(
    IdeaSettingsPlugin::class,
    EclipseSettingsPlugin::class,
    GradleWrapperSettingsPlugin::class,
    DependenciesExtensionsPlugin::class,
    ReportsSettingsPlugin::class,
    ComponentCapabilitiesPlugin::class
)
class CommonSettingsPlugin : BaseReflectiveProjectPlugin() {

    @PluginAction
    fun TaskContainer.`Set duplicates strategy to WARN for copying tasks`() {
        all {
            if (it is CopySpec) {
                it.duplicatesStrategy = WARN
            }
        }
    }

    @PluginAction
    fun TaskContainer.`Turn ON reproducible file order for archive tasks`() {
        all(AbstractArchiveTask::class.java) {
            it.isReproducibleFileOrder = true
        }
    }

    @PluginAction
    fun ConfigurationContainer.`Disable dependency transitivity if configuration is not transitive`() {
        all { conf ->
            conf.dependencies.all { dep ->
                if (!conf.isTransitive && dep is ModuleDependency) {
                    dep.isTransitive = false
                }
            }
        }
    }

    @PluginAction
    fun Project.`Copy project group to all sub-projects`() {
        if (isGroupSet) {
            setAllprojectsGroup(group.toString())
        }
    }

    @PluginAction
    fun Project.`Copy project version to all sub-projects`() {
        if (isVersionSet) {
            setAllprojectsVersion(version.toString())
        }
    }

}
