package name.remal.gradle_plugins.plugins.common

import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.CreateExtensionsPluginAction
import name.remal.gradle_plugins.dsl.Extension
import name.remal.gradle_plugins.dsl.Plugin
import name.remal.gradle_plugins.dsl.utils.getGradleLogger
import org.gradle.api.plugins.ExtensionContainer
import java.util.*
import kr.motd.maven.os.Detector as DetectorImpl

@Plugin(
    id = "name.remal.osdetector",
    description = "Plugin that provides osdetector extension.",
    tags = ["os", "osdetector", "os-detector"]
)
class OSDetectorPlugin : BaseReflectiveProjectPlugin() {

    @CreateExtensionsPluginAction
    fun ExtensionContainer.`Create osdetector extension`(): OSDetectorExtension {
        return create("osdetector", OSDetectorExtension::class.java)
    }

}


@Extension
class OSDetectorExtension : Detector by DetectorObject


private interface Detector {
    val name: String?
    val arch: String?
    val classifier: String?
    val version: String?
}

private object DetectorObject : DetectorImpl(), Detector {

    private val properties: Properties by lazy {
        Properties().apply {
            detect(this, null)
        }
    }

    override val name: String? get() = properties[DETECTED_NAME]?.toString()
    override val arch: String? get() = properties[DETECTED_ARCH]?.toString()
    override val classifier: String? get() = properties[DETECTED_CLASSIFIER]?.toString()
    override val version: String? get() = properties[DETECTED_VERSION]?.toString()

    override fun logProperty(name: String?, value: String?) {
        getGradleLogger(DetectorImpl::class.java).debug("{}={}", name, value)
    }

    override fun log(message: String?) {
        getGradleLogger(DetectorImpl::class.java).debug(message)
    }

}
