package name.remal.gradle_plugins.plugins.component_capabilities

import org.gradle.api.artifacts.ComponentMetadataContext
import org.gradle.api.artifacts.ComponentMetadataRule
import org.gradle.api.artifacts.ModuleVersionIdentifier
import org.gradle.api.capabilities.MutableCapabilitiesMetadata

abstract class AbstractComponentCapabilities : ComponentMetadataRule {

    protected abstract fun ModuleVersionIdentifier.process(capabilities: MutableCapabilitiesMetadata)

    final override fun execute(context: ComponentMetadataContext) {
        context.details.let { details ->
            details.allVariants {
                it.withCapabilities { capabilities ->
                    details.id.process(capabilities)
                }
            }
        }
    }


    protected fun MutableCapabilitiesMetadata.addCapability(group: String, name: String) = addCapability(group, "$name-capability", "0")

}
