package name.remal.gradle_plugins.plugins.component_capabilities

import name.remal.Services.loadImplementationClasses
import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.GradleEnumVersion.GRADLE_VERSION_4_9
import name.remal.gradle_plugins.dsl.MinGradleVersion
import name.remal.gradle_plugins.dsl.Plugin
import name.remal.gradle_plugins.dsl.PluginAction
import org.gradle.api.artifacts.dsl.DependencyHandler

@Plugin(
    id = "name.remal.component-capabilities",
    description = "Plugin that configures some default component capabilities.",
    tags = ["capabilities", "component-capabilities"]
)
@MinGradleVersion(GRADLE_VERSION_4_9)
class ComponentCapabilitiesPlugin : BaseReflectiveProjectPlugin() {

    companion object {
        private val capabilitiesClasses: List<Class<AbstractComponentCapabilities>> by lazy {
            loadImplementationClasses(AbstractComponentCapabilities::class.java).toList()
        }
    }

    @PluginAction(isHidden = true)
    protected fun DependencyHandler.registerComponentCapabilities() {
        capabilitiesClasses.forEach { components.all(it) }
    }

}
