package name.remal.gradle_plugins.plugins.component_capabilities.default_capabilities

import name.remal.gradle_plugins.api.AutoService
import name.remal.gradle_plugins.plugins.component_capabilities.AbstractComponentCapabilities
import org.gradle.api.artifacts.ModuleVersionIdentifier
import org.gradle.api.capabilities.MutableCapabilitiesMetadata

@AutoService
class LoggingCapabilities : AbstractComponentCapabilities() {

    override fun ModuleVersionIdentifier.process(capabilities: MutableCapabilitiesMetadata) {
        if (group == "org.slf4j" && name == "slf4j-api") {
            capabilities.addCapability("slf4j-api")
            return
        }
        if (group == "commons-logging" && name == "commons-logging") {
            capabilities.addCapability("jcl-api")
            return
        }
        if (group == "log4j" && name == "log4j") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-log4j12") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "ch.qos.logback" && name == "logback-classic") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-core") {
            capabilities.addCapability("log4j-impl")
            return
        }
        if (group == "org.slf4j" && name == "jcl-over-slf4j") {
            capabilities.addCapability("jcl-api")
            capabilities.addCapability("jcl-impl")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-api") {
            capabilities.addCapability("log4j-api")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-jcl") {
            capabilities.addCapability("jcl-impl")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-slf4j-impl") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.slf4j" && name == "log4j-over-slf4j") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-simple") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "commons-logging" && name == "commons-logging-api") {
            capabilities.addCapability("jcl-api")
            return
        }
        if (group == "log4j" && name == "apache-log4j-extras") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-1.2-api") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-jdk14") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.ops4j.pax.swissbox" && name == "pax-swissbox-optional-jcl") {
            capabilities.addCapability("jcl-api")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-nop") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.apache.logging.log4j" && name == "log4j-to-slf4j") {
            capabilities.addCapability("log4j-impl")
            return
        }
        if (group == "org.jboss.logmanager" && name == "log4j-jboss-logmanager") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.jboss.slf4j" && name == "slf4j-jboss-logmanager") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-jcl") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.jcabi" && name == "jcabi-maven-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.vmware.xenon" && name == "slf4j-xenon") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-android") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.springframework" && name == "spring-jcl") {
            capabilities.addCapability("jcl-api")
            capabilities.addCapability("jcl-impl")
            return
        }
        if (group == "com.gimbal.android.v2" && name == "gimbal-slf4j-impl") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.googlecode.slf4j-maven-plugin-log" && name == "slf4j-maven-plugin-log") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "net.peachjean.slf4j.mojo" && name == "slf4j-mojo") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.grails" && name == "grails-plugin-log4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.jboss.slf4j" && name == "slf4j-jboss-logging") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.kevoree.log" && name == "org.kevoree.log.compat.slf4j") {
            capabilities.addCapability("slf4j-api")
            return
        }
        if (group == "org.kill-bill.billing" && name == "killbill-platform-osgi-bundles-lib-slf4j-osgi") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.ops4j.pax.runner" && name == "pax-runner-no-jcl") {
            capabilities.addCapability("slf4j-api")
            capabilities.addCapability("jcl-impl")
            return
        }
        if (group == "org.slf4j" && name == "nlog4j") {
            capabilities.addCapability("slf4j-api")
            capabilities.addCapability("slf4j-impl")
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.spf4j" && name == "spf4j-slf4j-test") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.cisco.oss.foundation" && name == "logging-log4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.fireflysource" && name == "firefly-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.vmware.xenon" && name == "xenon-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.darkphoenixs" && name == "log4j") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.refcodes" && name == "refcodes-logger-ext-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.tinygroup" && name == "org.tinygroup.slf4j-log4j12") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.carrotgarden.maven" && name == "carrot-maven-slf4j-impl") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "com.turbo-rpc" && name == "turbo-jcl") {
            capabilities.addCapability("jcl-api")
            return
        }
        if (group == "org.apache.maven" && name == "maven-slf4j-provider") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.arakhne.afc.slf4j" && name == "slf4j-maven") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.gandon.tomcat" && name == "juli-to-slf4j") {
            capabilities.addCapability("slf4j-api")
            return
        }
        if (group == "org.mod4j.org.eclipse.xtext" && name == "log4j") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.slf4j" && name == "slf4j-log4j13") {
            capabilities.addCapability("slf4j-api")
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.sonatype.gossip" && name == "gossip-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.sonatype.install4j" && name == "install4j-slf4j") {
            capabilities.addCapability("slf4j-impl")
            return
        }
        if (group == "org.tinylog" && name == "log4j-facade") {
            capabilities.addCapability("log4j12-api")
            return
        }
        if (group == "org.tinylog" && name == "slf4j-binding") {
            capabilities.addCapability("slf4j-impl")
            return
        }
    }

    private fun MutableCapabilitiesMetadata.addCapability(name: String) = addCapability("logging", name)

}

