package name.remal.gradle_plugins.plugins.dependencies

import org.gradle.api.Project
import org.gradle.api.artifacts.Dependency
import org.gradle.api.artifacts.dsl.DependencyHandler
import org.gradle.api.invocation.Gradle
import java.io.File

class DependencyHandlerEmbeddedKotlinExtension(
    private val project: Project,
    private val dependencies: DependencyHandler,
    private val gradle: Gradle
) {

    private val libFiles: List<File> by lazy {
        val libDir = gradle.gradleHomeDir?.resolve("lib") ?: return@lazy emptyList<File>()
        return@lazy (libDir.listFiles() ?: emptyArray()).asSequence()
            .filter { it.name.startsWith("kotlin-") && it.name.endsWith(".jar") }
            .filter { !it.name.contains("compiler") }
            .filter(File::isFile)
            .map(File::getAbsoluteFile)
            .toList()
    }

    fun embeddedKotlin(): Dependency {
        return dependencies.create(project.files(project.provider { return@provider libFiles }))
    }

}
