package name.remal.gradle_plugins.plugins.dependencies

import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin
import name.remal.gradle_plugins.dsl.CreateExtensionsPluginAction
import name.remal.gradle_plugins.dsl.Plugin
import org.gradle.api.artifacts.ConfigurationContainer
import org.gradle.api.artifacts.dsl.DependencyHandler
import org.gradle.api.artifacts.dsl.RepositoryHandler
import org.gradle.api.plugins.ExtensionContainer

@Plugin(
    id = "name.remal.dependency-versions",
    description = "Plugin that provides 'dependencyVersions' extension.",
    tags = ["common", "dependencies"]
)
class DependencyVersionsPlugin : BaseReflectiveProjectPlugin() {

    @CreateExtensionsPluginAction
    fun ExtensionContainer.`Create 'dependencyVersions' extension`(dependencies: DependencyHandler, configurations: ConfigurationContainer, repositories: RepositoryHandler) {
        create("dependencyVersions", DependencyVersionsExtension::class.java, dependencies, configurations, repositories)
    }

}
