package name.remal.gradle_plugins.plugins.generate_sources

import name.remal.gradle_plugins.dsl.extensions.afterEvaluateOrNow
import name.remal.gradle_plugins.dsl.extensions.javaPackageName
import org.gradle.api.Task

interface GenerateClassTask<WriterType : BaseGeneratingClassWriter<WriterType>> : Task {

    fun classFile(packageName: String, simpleName: String, action: (writer: WriterType) -> Unit)

    fun classFile(simpleName: String, action: (writer: WriterType) -> Unit) {
        project.afterEvaluateOrNow(Int.MIN_VALUE) { _ ->
            classFile(project.javaPackageName, simpleName, action)
        }
    }

}
