package name.remal.gradle_plugins.plugins.gradle_plugins

import name.remal.gradle_plugins.dsl.extensions.convention
import name.remal.gradle_plugins.dsl.extensions.getOrNull
import name.remal.gradle_plugins.dsl.utils.DependencyNotation
import name.remal.gradle_plugins.dsl.utils.parseDependencyNotation
import name.remal.gradle_plugins.plugins.dependencies.DependencyHandlerCorrespondingKotlinExtension
import name.remal.gradle_plugins.plugins.dependencies.DependencyHandlerCorrespondingKotlinGradlePluginExtension
import name.remal.gradle_plugins.plugins.dependencies.DependencyHandlerEmbeddedKotlinExtension
import org.gradle.api.artifacts.Dependency
import org.gradle.api.artifacts.dsl.DependencyHandler

enum class CrossVersionGradleLibrary(
    notation: String,
    val dependencyFactory: DependencyHandler.() -> Dependency?
) {

    LOCAL_GROOVY("name.remal.gradle-api:local-groovy", DependencyHandler::localGroovy),

    GRADLE_API("name.remal.gradle-api:gradle-api", DependencyHandler::gradleApi),

    GRADLE_TEST_KIT("name.remal.gradle-api:gradle-test-kit", DependencyHandler::gradleTestKit),

    EMBEDDED_KOTLIN("name.remal.gradle-api:embedded-kotlin", { convention.getOrNull(DependencyHandlerEmbeddedKotlinExtension::class.java)?.embeddedKotlin() }),

    CORRESPONDING_KOTLIN("name.remal.gradle-api:embedded-kotlin", { convention.getOrNull(DependencyHandlerCorrespondingKotlinExtension::class.java)?.correspondingKotlin() }),

    CORRESPONDING_KOTLIN_PLUGIN("name.remal.gradle-api:corresponding-kotlin-plugin", { convention.getOrNull(DependencyHandlerCorrespondingKotlinGradlePluginExtension::class.java)?.correspondingKotlinGradlePlugin() }),

    ;

    val notation: DependencyNotation = parseDependencyNotation(notation)

}
