package name.remal.gradle_plugins.plugins.ide.idea

import name.remal.SERVICE_FILE_BASE_PATH
import name.remal.Services.readServiceLines
import name.remal.gradle_plugins.dsl.*
import name.remal.gradle_plugins.dsl.extensions.get
import name.remal.gradle_plugins.dsl.reflective_project_plugin.mixin.SkipIfOnlyCleanTasksAreRequestedToExecuteMixin
import name.remal.gradle_plugins.plugins.ci.SkipIfCommonCIPluginIsApplied
import name.remal.gradle_plugins.plugins.java.JavaAnyPluginId
import name.remal.toSet
import org.gradle.api.plugins.ExtensionContainer

@Plugin(
    id = "name.remal.idea-extended-settings",
    description = "Plugin that configures IDEA workspace.",
    tags = ["idea"]
)
@WithPlugins(IdeaPluginId::class)
@ApplyPluginClasses(IdeaSettingsPlugin::class)
class IdeaExtendedSettingsPlugin : BaseReflectiveProjectPlugin(), SkipIfOnlyCleanTasksAreRequestedToExecuteMixin, SkipIfCommonCIPluginIsApplied {

    @PluginAction
    @WithPlugins(JavaAnyPluginId::class)
    fun ExtensionContainer.`Setup EntryPointsManager - entry points annotations`() {
        this[IDEASettings::class.java].entryPointAnnotations(
            readServiceLines("$SERVICE_FILE_BASE_PATH/${EntryPointAnnotation::class.java.name}").toSet()
        )
    }

    @PluginAction
    @WithPlugins(JavaAnyPluginId::class)
    fun ExtensionContainer.`Setup EntryPointsManager - write annotations`() {
        this[IDEASettings::class.java].writeAnnotations(
            readServiceLines("$SERVICE_FILE_BASE_PATH/${WriteAnnotation::class.java.name}").toSet()
        )
    }

    @PluginAction
    @WithPlugins(JavaAnyPluginId::class)
    fun ExtensionContainer.`Setup NullableNotNullManager - Nullable annotations`() {
        this[IDEASettings::class.java].nullableAnnotations(
            readServiceLines("$SERVICE_FILE_BASE_PATH/${NullableAnnotation::class.java.name}").toSet()
        )
    }

    @PluginAction
    @WithPlugins(JavaAnyPluginId::class)
    fun ExtensionContainer.`Setup NullableNotNullManager - NotNull annotations`() {
        this[IDEASettings::class.java].notNullAnnotations(
            readServiceLines("$SERVICE_FILE_BASE_PATH/${NotNullAnnotation::class.java.name}").toSet()
        )
    }

    @PluginAction
    @WithPlugins(JavaAnyPluginId::class)
    fun ExtensionContainer.`Setup CompilerConfiguration - add default annotation-processing profile`() {
        this[IDEASettings::class.java].addDefaultAnnotationProcessingProfile()
    }

}

