package name.remal.gradle_plugins.plugins.ide.idea

import name.remal.getOrCreateChild
import name.remal.gradle_plugins.dsl.*
import name.remal.gradle_plugins.dsl.extensions.applyPlugin
import name.remal.gradle_plugins.dsl.extensions.get
import name.remal.gradle_plugins.dsl.extensions.isRootProject
import name.remal.gradle_plugins.plugins.ci.SkipIfCommonCIPluginIsApplied
import org.gradle.api.Action
import org.gradle.api.Project
import org.gradle.api.plugins.ExtensionContainer

@Plugin(
    id = "name.remal.idea-external-annotations",
    description = "Plugin that adds external annotations default link (file://\$USER_HOME\$/idea-external-annotations) to IDEA project libraries.",
    tags = ["idea"]
)
@WithPlugins(IdeaPluginId::class)
@ApplyPluginClasses(IdeaSettingsPlugin::class)
class IdeaExternalAnnotationsPlugin : BaseReflectiveProjectPlugin(), SkipIfCommonCIPluginIsApplied {

    @PluginAction(order = Int.MIN_VALUE, isHidden = true)
    fun Project.`Apply this plugin for all projects`() {
        rootProject.allprojects {
            it.applyPlugin(IdeaExternalAnnotationsPlugin::class.java)
        }
    }

    @PluginAction(isHidden = true)
    fun ExtensionContainer.addExternalAnnotationsDefaultLink(project: Project) {
        if (!project.isRootProject) return
        this[IDEASettings::class.java].configureIDEAComponent("libraryTable", "libraries/", Action { componentElement ->
            componentElement.getChildren("library").forEach { libraryElement ->
                val annotationsRootElement = libraryElement.getOrCreateChild("ANNOTATIONS").getOrCreateChild("root")
                if (null == annotationsRootElement.getAttribute("url")) {
                    annotationsRootElement.setAttribute("url", "file://\$USER_HOME\$/idea-external-annotations")
                }
            }
        })
    }

}
