package name.remal.gradle_plugins.plugins.ide.idea

import name.remal.gradle_plugins.dsl.*
import name.remal.gradle_plugins.dsl.extensions.*
import name.remal.gradle_plugins.plugins.java.JavaAnyPluginId
import org.gradle.api.Project
import org.gradle.api.artifacts.ConfigurationContainer
import org.gradle.api.plugins.ExtensionContainer
import org.gradle.plugins.ide.idea.model.IdeaModel
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope

@Plugin(
    id = "name.remal.idea-settings",
    description = "Plugin that configures 'idea' plugin if it's applied.",
    tags = ["idea"]
)
@WithPlugins(IdeaPluginId::class)
@ApplyPluginClassesAtTheEnd(IdeaExtendedSettingsPlugin::class)
class IdeaSettingsPlugin : BaseReflectiveProjectPlugin() {

    @CreateExtensionsPluginAction
    fun ExtensionContainer.`Create 'ideaSettings' extension`(project: Project) {
        if (project.isRootProject) {
            create(IDEASettings::class.java, "ideaSettings", IDEASettingsExtension::class.java, project)
        } else {
            create(IDEASettings::class.java, "ideaSettings", IdeaSettingsDelegateToRoot::class.java)
        }
    }

    @PluginAction(order = Int.MIN_VALUE)
    fun Project.`Apply 'idea' and this plugins for all projects`() {
        rootProject.allprojects {
            it.applyPlugin(IdeaPluginId)
            it.applyPlugin(IdeaSettingsPlugin::class.java)
        }
    }

    @PluginAction
    fun ExtensionContainer.`Turn ON downloading dependency javadoc`() {
        this[IdeaModel::class.java].module?.apply {
            isDownloadJavadoc = true
        }
    }

    @PluginAction
    fun ExtensionContainer.`Turn ON downloading dependency sources`() {
        this[IdeaModel::class.java].module?.apply {
            isDownloadSources = true
        }
    }

    @PluginActionsGroup
    @WithPlugins(JavaAnyPluginId::class)
    inner class `For java project` {

        @PluginAction
        fun ExtensionContainer.`Remove compileOnly configuration from TEST scope`(configurations: ConfigurationContainer) {
            this[IdeaModel::class.java].module?.apply {
                removeFromScope(GeneratedIdeaScope.TEST, configurations.compileOnly)
            }
        }

    }

}
