package name.remal.gradle_plugins.plugins.merge_resources

import org.gradle.api.file.RelativePath
import org.gradle.api.internal.file.pattern.PatternMatcherFactory
import org.gradle.api.specs.Spec

abstract class BaseResourceMerger(final override val pattern: String) : ResourceMerger {

    private val caseSensitivePatternMatcher: Spec<RelativePath> = PatternMatcherFactory.getPatternMatcher(false, true, pattern)
    private val caseInsensitivePatternMatcher: Spec<RelativePath> = PatternMatcherFactory.getPatternMatcher(false, false, pattern)

    final override fun getPatternMatcher(isCaseSensitive: Boolean) = if (isCaseSensitive) {
        caseSensitivePatternMatcher
    } else {
        caseInsensitivePatternMatcher
    }

}
