package name.remal.gradle_plugins.plugins.publish.nexus_staging

import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path

interface NexusStagingApi {

    @GET("service/local/staging/profiles")
    fun getProfiles(): NexusStagingData<List<NexusStagingProfile>>

    @GET("service/local/staging/profile_repositories/{profileId}")
    fun getProfileRepositories(@Path("profileId") profileId: String): NexusStagingData<List<NexusStagingRepository>>

    @GET("service/local/staging/repository/{repositoryId}")
    fun getRepository(@Path("repositoryId") repositoryId: String): NexusStagingRepository

    @GET("service/local/staging/repository/{repositoryId}/activity")
    fun getRepositoryActivity(@Path("repositoryId") repositoryId: String): List<NexusStagingRepositoryAction>

    @POST("service/local/staging/bulk/{action}")
    fun bulkAction(@Path("action") action: String, @Body data: NexusStagingData<NexusStagingBulkActionRequest>): Call<Void>

    fun bulkAction(action: String, vararg stagedRepositoryIds: String) = bulkAction(action, NexusStagingData(NexusStagingBulkActionRequest(stagedRepositoryIds = stagedRepositoryIds.toList())))


    @GET("service/local/repositories/{repositoryId}/content/{relativePath}")
    fun getRepositoryContent(@Path("repositoryId") repositoryId: String, @Path("relativePath") relativePath: String): NexusStagingData<List<NexusRepositoryContentItem>>

}
