package name.remal.gradle_plugins.plugins.testing

import name.remal.gradle_plugins.api.AutoService
import name.remal.gradle_plugins.dsl.extensions.applyPlugin
import name.remal.gradle_plugins.dsl.reflective_project_plugin.action_param_injector.ActionParamInjector
import name.remal.gradle_plugins.plugins.java.JavaAnyPluginId
import org.gradle.api.Project

@AutoService
class TestSourceSetContainerActionParamInjector : ActionParamInjector<TestSourceSetContainer>() {

    override fun createValue(project: Project): TestSourceSetContainer {
        project.extensions.findByType(TestSourceSetContainer::class.java)?.let { return it }
        project.applyPlugin(JavaAnyPluginId)
        project.applyPlugin(TestSourceSetsPlugin::class.java)
        return project.extensions.getByType(TestSourceSetContainer::class.java)
    }

}
