package name.remal.gradle_plugins.plugins.vcs

import name.remal.emptyStream
import name.remal.gradle_plugins.dsl.utils.getGradleLogger
import java.io.File

class VcsOperationsUnsupported(context: Any? = "project") : VcsOperations() {

    companion object {
        private val logger = getGradleLogger(VcsOperationsUnsupported::class.java)
    }

    private val NOT_SUPPORTED_MESSAGE = "VCS operations are not supported for $context"

    override val vcsRootDir get() = throw UnsupportedOperationException(NOT_SUPPORTED_MESSAGE)

    override val masterBranch get() = ""

    override val currentBranch: String? get() = null

    override val isCommitted get() = false

    override var commitAuthor: CommitAuthor? = null

    override fun walkCommits() = emptyStream<Commit>()

    override fun commitFiles(message: String, files: Collection<File>) = throw UnsupportedOperationException(NOT_SUPPORTED_MESSAGE)

    override fun getAllTagNames() = emptySet<String>()

    override fun createTag(commitId: String, tagName: String, message: String) = throw UnsupportedOperationException(NOT_SUPPORTED_MESSAGE)

    override fun findTagWithDepth(predicate: (tagName: String) -> Boolean): TagsWithDepth? = null

    override fun setUnauthorizedRemoteURI(uri: String) {
        logger.error(NOT_SUPPORTED_MESSAGE)
    }

    override fun setUsernamePasswordAuth(username: String, password: CharArray) {
        logger.error(NOT_SUPPORTED_MESSAGE)
    }

    override fun setSSHAuth(privateKeyFile: File, password: CharArray?) {
        logger.error(NOT_SUPPORTED_MESSAGE)
    }

}
