package name.remal.gradle_plugins.utils

import com.google.common.annotations.VisibleForTesting
import name.remal.json.data_format.DataFormatJSON.JSON_DATA_FORMAT
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.jackson.JacksonConverterFactory

private val RETROFIT_JSON_OBJECT_MAPPER = JSON_DATA_FORMAT.objectMapper

fun newJsonRetrofitBuilder(httpClientConfigurer: (httpClientBuilder: OkHttpClient.Builder) -> OkHttpClient.Builder = { it }): Retrofit.Builder {
    return newRetrofitBuilder {
        httpClientConfigurer(it.addInterceptor {
            it.proceed(it.request().newBuilder()
                .addHeader("Accept", "application/json")
                .build())
        })
    }
        .addConverterFactory(JacksonConverterFactory.create(RETROFIT_JSON_OBJECT_MAPPER))
}

@VisibleForTesting
internal fun <T> __parseWithRetrofitJsonObjectMapper(content: String, type: Class<T>): T = RETROFIT_JSON_OBJECT_MAPPER.readValue(content, type)
