/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Type;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonFormat;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonGenerator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.AnnotationIntrospector;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.BeanProperty;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JavaType;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonMappingException;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonNode;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializerProvider;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.type.TypeFactory;

@JacksonStdImpl
@RelocatedClass
@Generated
@SuppressFBWarnings
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, prop, unwrapSingle);
        this._elementSerializer = ser;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringArraySerializer(this, prop, this._elementSerializer, unwrapSingle);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property2) throws JsonMappingException {
        JsonSerializer<Object> ser = null;
        if (property2 != null) {
            Object serDef;
            AnnotationIntrospector ai = provider.getAnnotationIntrospector();
            AnnotatedMember m = property2.getMember();
            if (m != null && (serDef = ai.findContentSerializer(m)) != null) {
                ser = provider.serializerInstance(m, serDef);
            }
        }
        Boolean unwrapSingle = this.findFormatFeature(provider, property2, String[].class, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(provider, property2, ser)) == null) {
            ser = provider.findValueSerializer(String.class, property2);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        if (ser == this._elementSerializer && unwrapSingle == this._unwrapSingle) {
            return this;
        }
        return new StringArraySerializer(this, property2, ser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, String[] value) {
        return value.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value) {
        return value.length == 1;
    }

    @Override
    public final void serialize(String[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.length;
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(String[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value, gen, provider, this._elementSerializer);
            return;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            String str = value[i2];
            if (str == null) {
                gen.writeNull();
                continue;
            }
            gen.writeString(value[i2]);
        }
    }

    private void serializeContentsSlow(String[] value, JsonGenerator gen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException {
        int len = value.length;
        for (int i2 = 0; i2 < len; ++i2) {
            String str = value[i2];
            if (str == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            ser.serialize(value[i2], gen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        this.visitArrayFormat(visitor2, typeHint, JsonFormatTypes.STRING);
    }
}

