/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.signature;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.OAuth;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthMessageSignerException;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.http.HttpParameters;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.http.HttpRequest;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.signature.OAuthMessageSigner;
import name.remal.gradle_plugins.internal._relocated.com.gradle.publish.plugin.dep.oauth.signpost.signature.SignatureBaseString;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class HmacSha1MessageSigner
extends OAuthMessageSigner {
    private static final String MAC_NAME = "HmacSHA1";

    public String getSignatureMethod() {
        return "HMAC-SHA1";
    }

    public String sign(HttpRequest request, HttpParameters requestParams) throws OAuthMessageSignerException {
        try {
            String keyString = OAuth.percentEncode(this.getConsumerSecret()) + '&' + OAuth.percentEncode(this.getTokenSecret());
            byte[] keyBytes = keyString.getBytes("UTF-8");
            SecretKeySpec key = new SecretKeySpec(keyBytes, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(key);
            String sbs = new SignatureBaseString(request, requestParams).generate();
            OAuth.debugOut("SBS", sbs);
            byte[] text = sbs.getBytes("UTF-8");
            return this.base64Encode(mac.doFinal(text)).trim();
        }
        catch (GeneralSecurityException e) {
            throw new OAuthMessageSignerException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthMessageSignerException(e);
        }
    }
}

