/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.HasName;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ObjectTypedValueWrapper;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResultObject;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class AnnotationParameterValue
extends ScanResultObject
implements HasName,
Comparable<AnnotationParameterValue> {
    private String name;
    private ObjectTypedValueWrapper value;

    AnnotationParameterValue() {
    }

    AnnotationParameterValue(String name, Object value) {
        this.name = name;
        this.value = new ObjectTypedValueWrapper(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value == null ? null : this.value.get();
    }

    void setValue(Object newValue) {
        this.value = new ObjectTypedValueWrapper(newValue);
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.value != null) {
            this.value.setScanResult(scanResult);
        }
    }

    @Override
    protected void findReferencedClassInfo(Map<String, ClassInfo> classNameToClassInfo, Set<ClassInfo> refdClassInfo) {
        if (this.value != null) {
            this.value.findReferencedClassInfo(classNameToClassInfo, refdClassInfo);
        }
    }

    void convertWrapperArraysToPrimitiveArrays(ClassInfo annotationClassInfo) {
        if (this.value != null) {
            this.value.convertWrapperArraysToPrimitiveArrays(annotationClassInfo, this.name);
        }
    }

    Object instantiate(ClassInfo annotationClassInfo) {
        return this.value.instantiateOrGet(annotationClassInfo, this.name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    void toString(StringBuilder buf) {
        buf.append(this.name);
        buf.append("=");
        this.toStringParamValueOnly(buf);
    }

    void toStringParamValueOnly(StringBuilder buf) {
        if (this.value == null) {
            buf.append("null");
        } else {
            Object paramVal = this.value.get();
            Class<?> valClass = paramVal.getClass();
            if (valClass.isArray()) {
                buf.append('[');
                int n = Array.getLength(paramVal);
                for (int j = 0; j < n; ++j) {
                    Object elt;
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append((elt = Array.get(paramVal, j)) == null ? "null" : elt.toString());
                }
                buf.append(']');
            } else if (paramVal instanceof String) {
                buf.append('\"');
                buf.append(paramVal.toString().replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\"');
            } else if (paramVal instanceof Character) {
                buf.append('\'');
                buf.append(paramVal.toString().replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r"));
                buf.append('\'');
            } else {
                buf.append(paramVal.toString());
            }
        }
    }

    private String toStringParamValueOnly() {
        StringBuilder buf = new StringBuilder();
        this.toStringParamValueOnly(buf);
        return buf.toString();
    }

    @Override
    public int compareTo(AnnotationParameterValue other) {
        if (other == this) {
            return 0;
        }
        int diff = this.name.compareTo(other.getName());
        if (diff != 0) {
            return diff;
        }
        if (this.value.equals(other.value)) {
            return 0;
        }
        Object p0 = this.getValue();
        Object p1 = other.getValue();
        return p0 == null || p1 == null ? (p0 == null ? 0 : 1) - (p1 == null ? 0 : 1) : this.toStringParamValueOnly().compareTo(other.toStringParamValueOnly());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AnnotationParameterValue)) {
            return false;
        }
        AnnotationParameterValue other = (AnnotationParameterValue)obj;
        return this.name.equals(other.name) && this.value == null == (other.value == null) && (this.value == null || this.value.equals(other.value));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

