/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClasspathElementModule;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.Resource;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ResourceList;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ScanResult;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.JarUtils;

@RelocatedClass
@Generated
@SuppressFBWarnings
class ClassGraphClassLoader
extends ClassLoader {
    private final ScanResult scanResult;

    ClassGraphClassLoader(ScanResult scanResult) {
        super(null);
        this.scanResult = scanResult;
        ClassGraphClassLoader.registerAsParallelCapable();
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException, LinkageError, SecurityException {
        Class<?> loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        ClassInfo classInfo = this.scanResult.getClassInfo(className);
        boolean triedClassInfoLoader = false;
        ClassLoader[] classLoaderOrder = this.scanResult.getClassLoaderOrderRespectingParentDelegation();
        if (classLoaderOrder != null) {
            for (ClassLoader envClassLoader : classLoaderOrder) {
                try {
                    return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, envClassLoader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    if (classInfo == null || envClassLoader != classInfo.classLoader) continue;
                    triedClassInfoLoader = true;
                }
            }
        }
        try {
            return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, null);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            Iterator iterator;
            if (!triedClassInfoLoader && classInfo != null && classInfo.classLoader != null) {
                try {
                    return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, classInfo.classLoader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable2) {
                    // empty catch block
                }
            }
            if (classInfo != null && classInfo.classpathElement instanceof ClasspathElementModule && !classInfo.isPublic()) {
                throw new ClassNotFoundException("Classfile for class " + className + " was found in a module, but the context and system classloaders could not load the class, probably because the class is not public.");
            }
            ResourceList classfileResources = this.scanResult.getResourcesWithPath(JarUtils.classNameToClassfilePath(className));
            if (classfileResources != null && (iterator = classfileResources.iterator()).hasNext()) {
                try (Resource resource2 = (Resource)iterator.next();){
                    ByteBuffer resourceByteBuffer = resource2.read();
                    Class<?> clazz = this.defineClass(className, resourceByteBuffer, null);
                    return clazz;
                }
            }
            throw new ClassNotFoundException("Could not load classfile for class " + className);
        }
    }

    @Override
    public URL getResource(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResource(path);
        }
        return ((Resource)resourceList.get(0)).getURL();
    }

    @Override
    public Enumeration<URL> getResources(String path) throws IOException {
        final ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResources(path);
        }
        return new Enumeration<URL>(){
            int idx;

            @Override
            public boolean hasMoreElements() {
                return this.idx < resourceList.size();
            }

            @Override
            public URL nextElement() {
                return ((Resource)resourceList.get(this.idx++)).getURL();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResourceAsStream(path);
        }
        try {
            return ((Resource)resourceList.get(0)).open();
        }
        catch (IOException e) {
            return null;
        }
    }
}

