/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classloaderhandler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.ReflectionUtils;

@RelocatedClass
@Generated
@SuppressFBWarnings
class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass) {
        return "org.jboss.modules.ModuleClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true);
        classLoaderOrder.add(classLoader);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        File file;
        if (resourceLoader == null) {
            return;
        }
        Object root = ReflectionUtils.getFieldVal(resourceLoader, "root", false);
        File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile", false);
        String path = null;
        if (physicalFile != null) {
            File file2;
            String name = (String)ReflectionUtils.invokeMethod(root, "getName", false);
            path = name != null ? (FileUtils.canRead(file2 = new File(physicalFile.getParentFile(), name)) ? file2.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
        } else {
            path = (String)ReflectionUtils.invokeMethod(root, "getPathName", false);
            if (path == null) {
                File file3 = root instanceof Path ? ((Path)root).toFile() : (file = root instanceof File ? (File)root : null);
                if (file != null) {
                    path = file.getAbsolutePath();
                }
            }
        }
        if (path == null && (file = (File)ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar", false)) != null) {
            path = file.getAbsolutePath();
        }
        if (path != null) {
            classpathOrderOut.addClasspathEntry(path, classLoader, scanSpec, log);
        } else if (log != null) {
            log.log("Could not determine classpath for ResourceLoader: " + resourceLoader);
        }
    }

    private static void handleRealModule(Object module2, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module2)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)ReflectionUtils.invokeMethod(module2, "getClassLoader", false);
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders", false)) != null) {
            int n = Array.getLength(vfsResourceLoaders);
            for (int i2 = 0; i2 < n; ++i2) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i2);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object module2 = ReflectionUtils.invokeMethod(classLoader, "getModule", false);
        Object callerModuleLoader = ReflectionUtils.invokeMethod(module2, "getCallerModuleLoader", false);
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(callerModuleLoader, "moduleMap", false);
        for (Map.Entry ent : moduleMap.entrySet()) {
            Object val = ent.getValue();
            Object realModule = ReflectionUtils.invokeMethod(val, "getModule", false);
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
        }
        Map pathsMap = (Map)ReflectionUtils.invokeMethod(module2, "getPaths", false);
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = ReflectionUtils.getFieldVal(localLoader, "this$0", false);
                Object realModule = ReflectionUtils.getFieldVal(moduleClassLoader, "module", false);
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
            }
        }
    }
}

