/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ClassGraphException;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ModuleReaderProxy;
import name.remal.gradle_plugins.internal._relocated.io.github.classgraph.ModuleRef;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.concurrency.SingletonMap;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.LogicalZipFile;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.PhysicalZipFile;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.RecyclableInflater;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.recycler.Recycler;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FastPathResolver;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class NestedJarHandler {
    private final ScanSpec scanSpec;
    private SingletonMap<File, PhysicalZipFile, IOException> canonicalFileToPhysicalZipFileMap = new SingletonMap<File, PhysicalZipFile, IOException>(){

        @Override
        public PhysicalZipFile newInstance(File canonicalFile, LogNode log) throws IOException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            return new PhysicalZipFile(canonicalFile, NestedJarHandler.this);
        }
    };
    private Queue<PhysicalZipFile> additionalAllocatedPhysicalZipFiles = new ConcurrentLinkedQueue<PhysicalZipFile>();
    private SingletonMap<FastZipEntry, ZipFileSlice, IOException> fastZipEntryToZipFileSliceMap = new SingletonMap<FastZipEntry, ZipFileSlice, IOException>(){

        @Override
        public ZipFileSlice newInstance(FastZipEntry childZipEntry, LogNode log) throws IOException, InterruptedException {
            ZipFileSlice childZipEntrySlice;
            if (!childZipEntry.isDeflated) {
                childZipEntrySlice = new ZipFileSlice(childZipEntry);
            } else {
                InputStream inputStream;
                if (childZipEntry.uncompressedSize < 0L || childZipEntry.uncompressedSize >= 0x2000000L || childZipEntry.compressedSize >= 0x2000000L) {
                    File tempFile = null;
                    try {
                        tempFile = NestedJarHandler.this.makeTempFile(childZipEntry.entryName, true);
                        if (log != null) {
                            log.log("Deflating zip entry to temporary file: " + childZipEntry + " ; uncompressed size: " + childZipEntry.uncompressedSize + " ; temp file: " + tempFile);
                        }
                        inputStream = childZipEntry.open();
                        try {
                            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        PhysicalZipFile physicalZipFile = NestedJarHandler.this.canonicalFileToPhysicalZipFile(tempFile, log);
                        NestedJarHandler.this.additionalAllocatedPhysicalZipFiles.add(physicalZipFile);
                        childZipEntrySlice = new ZipFileSlice(physicalZipFile);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        block27: {
                            if (log != null) {
                                log.log("Deflating zip entry to temporary file failed: " + e);
                            }
                            if (tempFile != null) {
                                try {
                                    Files.delete(tempFile.toPath());
                                }
                                catch (IOException | SecurityException e2) {
                                    if (log == null) break block27;
                                    log.log("Removing temporary file failed: " + e2);
                                }
                            }
                        }
                        childZipEntrySlice = null;
                    }
                } else {
                    childZipEntrySlice = null;
                }
                if (childZipEntrySlice == null) {
                    ByteBuffer byteBuffer;
                    if (childZipEntry.uncompressedSize > 0x7FFFFFF7L) {
                        throw new IOException("Uncompressed size of zip entry (" + childZipEntry.uncompressedSize + ") is too large to inflate to memory: " + childZipEntry.entryName);
                    }
                    if (log != null) {
                        log.log("Deflating zip entry to RAM: " + childZipEntry + " ; uncompressed size: " + childZipEntry.uncompressedSize);
                    }
                    inputStream = childZipEntry.open();
                    try {
                        byteBuffer = ByteBuffer.wrap(FileUtils.readAllBytesAsArray(inputStream, childZipEntry.uncompressedSize));
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    PhysicalZipFile physicalZipFileInRam = new PhysicalZipFile(byteBuffer, childZipEntry.parentLogicalZipFile.physicalZipFile.getFile(), childZipEntry.getPath(), NestedJarHandler.this);
                    NestedJarHandler.this.additionalAllocatedPhysicalZipFiles.add(physicalZipFileInRam);
                    childZipEntrySlice = new ZipFileSlice(physicalZipFileInRam, childZipEntry);
                }
            }
            return childZipEntrySlice;
        }
    };
    private SingletonMap<ZipFileSlice, LogicalZipFile, IOException> zipFileSliceToLogicalZipFileMap = new SingletonMap<ZipFileSlice, LogicalZipFile, IOException>(){

        @Override
        public LogicalZipFile newInstance(ZipFileSlice zipFileSlice, LogNode log) throws IOException, InterruptedException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            LogicalZipFile logicalZipFile = new LogicalZipFile(zipFileSlice, log);
            NestedJarHandler.this.allocatedLogicalZipFiles.add(logicalZipFile);
            return logicalZipFile;
        }
    };
    private final Queue<LogicalZipFile> allocatedLogicalZipFiles = new ConcurrentLinkedQueue<LogicalZipFile>();
    public SingletonMap<String, Map.Entry<LogicalZipFile, String>, IOException> nestedPathToLogicalZipFileAndPackageRootMap = new SingletonMap<String, Map.Entry<LogicalZipFile, String>, IOException>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map.Entry<LogicalZipFile, String> newInstance(String nestedJarPathRaw, LogNode log) throws IOException, InterruptedException {
            ZipFileSlice childZipEntrySlice;
            Map.Entry<LogicalZipFile, String> parentLogicalZipFileAndPackageRoot;
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            String nestedJarPath = FastPathResolver.resolve(nestedJarPathRaw);
            int lastPlingIdx = nestedJarPath.lastIndexOf(33);
            if (lastPlingIdx < 0) {
                PhysicalZipFile physicalZipFile;
                boolean isRemote;
                boolean bl = isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                if (isRemote) {
                    if (!((NestedJarHandler)NestedJarHandler.this).scanSpec.enableRemoteJarScanning) throw new IOException("Remote jar scanning has not been enabled, cannot scan classpath element: " + nestedJarPath);
                    physicalZipFile = NestedJarHandler.this.downloadJarFromURL(nestedJarPath, log);
                } else {
                    try {
                        File canonicalFile = new File(nestedJarPath).getCanonicalFile();
                        physicalZipFile = NestedJarHandler.this.canonicalFileToPhysicalZipFile(canonicalFile, log);
                    }
                    catch (SecurityException e) {
                        throw new IOException("Path component " + nestedJarPath + " could not be canonicalized: " + e);
                    }
                }
                ZipFileSlice topLevelSlice = new ZipFileSlice(physicalZipFile);
                try {
                    LogicalZipFile logicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(topLevelSlice, log);
                    return new AbstractMap.SimpleEntry<LogicalZipFile, String>(logicalZipFile, "");
                }
                catch (SingletonMap.NullSingletonException e) {
                    throw new IOException("Could not get toplevel slice " + topLevelSlice + " : " + e);
                }
            }
            String parentPath = nestedJarPath.substring(0, lastPlingIdx);
            String childPath = nestedJarPath.substring(lastPlingIdx + 1);
            childPath = FileUtils.sanitizeEntryPath(childPath, true);
            try {
                parentLogicalZipFileAndPackageRoot = NestedJarHandler.this.nestedPathToLogicalZipFileAndPackageRootMap.get(parentPath, log);
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Could not get parent logical zipfile " + parentPath + " : " + e);
            }
            LogicalZipFile parentLogicalZipFile = parentLogicalZipFileAndPackageRoot.getKey();
            boolean isDirectory = false;
            while (childPath.endsWith("/")) {
                isDirectory = true;
                childPath = childPath.substring(0, childPath.length() - 1);
            }
            FastZipEntry childZipEntry = null;
            if (!isDirectory) {
                for (FastZipEntry fastZipEntry : parentLogicalZipFile.entries) {
                    if (!fastZipEntry.entryName.equals(childPath)) continue;
                    childZipEntry = fastZipEntry;
                    break;
                }
            }
            if (childZipEntry == null) {
                String childPathPrefix = childPath + "/";
                for (FastZipEntry entry : parentLogicalZipFile.entries) {
                    if (!entry.entryName.startsWith(childPathPrefix)) continue;
                    isDirectory = true;
                    break;
                }
                if (!isDirectory) {
                    throw new IOException("Path " + childPath + " does not exist in jarfile " + parentLogicalZipFile);
                }
            }
            if (isDirectory) {
                if (childPath.isEmpty()) return new AbstractMap.SimpleEntry<LogicalZipFile, String>(parentLogicalZipFile, childPath);
                if (log != null) {
                    log.log("Path " + childPath + " in jarfile " + parentLogicalZipFile + " is a directory, not a file -- using as package root");
                }
                parentLogicalZipFile.classpathRoots.add(childPath);
                return new AbstractMap.SimpleEntry<LogicalZipFile, String>(parentLogicalZipFile, childPath);
            }
            if (!((NestedJarHandler)NestedJarHandler.this).scanSpec.scanNestedJars) {
                throw new IOException("Nested jar scanning is disabled -- skipping nested jar " + nestedJarPath);
            }
            try {
                childZipEntrySlice = (ZipFileSlice)NestedJarHandler.this.fastZipEntryToZipFileSliceMap.get(childZipEntry, log);
            }
            catch (SingletonMap.NullSingletonException nullSingletonException) {
                throw new IOException("Could not get child zip entry slice " + childZipEntry + " : " + nullSingletonException);
            }
            LogNode logNode = log == null ? null : log.log("Getting zipfile slice " + childZipEntrySlice + " for nested jar " + childZipEntry.entryName);
            try {
                LogicalZipFile childLogicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(childZipEntrySlice, logNode);
                return new AbstractMap.SimpleEntry<LogicalZipFile, String>(childLogicalZipFile, "");
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Could not get child logical zipfile " + childZipEntrySlice + " : " + e);
            }
        }
    };
    public SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>, IOException> moduleRefToModuleReaderProxyRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>, IOException>(){

        @Override
        public Recycler<ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode ignored) {
            return new Recycler<ModuleReaderProxy, IOException>(){

                @Override
                public ModuleReaderProxy newInstance() throws IOException {
                    if (NestedJarHandler.this.closed.get()) {
                        throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
                    }
                    return moduleRef.open();
                }
            };
        }
    };
    Recycler<RecyclableInflater, RuntimeException> inflaterRecycler = new Recycler<RecyclableInflater, RuntimeException>(){

        @Override
        public RecyclableInflater newInstance() throws RuntimeException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            return new RecyclableInflater();
        }
    };
    private ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";
    private static final int INFLATE_TO_DISK_THRESHOLD = 0x2000000;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public InterruptionChecker interruptionChecker;

    public NestedJarHandler(ScanSpec scanSpec, InterruptionChecker interruptionChecker) {
        this.scanSpec = scanSpec;
        this.interruptionChecker = interruptionChecker;
    }

    private PhysicalZipFile canonicalFileToPhysicalZipFile(File canonicalFile, LogNode log) throws IOException, InterruptedException {
        try {
            return this.canonicalFileToPhysicalZipFileMap.get(canonicalFile, log);
        }
        catch (SingletonMap.NullSingletonException e) {
            throw new IOException("Could not get physical zipfile " + canonicalFile + " : " + e);
        }
    }

    private static String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace(' ', '_');
    }

    private File makeTempFile(String filePath, boolean onlyUseLeafname) throws IOException {
        File tempFile = File.createTempFile("ClassGraph--", TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(onlyUseLeafname ? NestedJarHandler.leafname(filePath) : filePath));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    private PhysicalZipFile downloadJarFromURL(String jarURL, LogNode log) throws IOException, InterruptedException {
        URL url;
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading jar from URL " + jarURL);
        try {
            url = new URL(jarURL);
        }
        catch (MalformedURLException e) {
            throw new IOException("Malformed URL: " + jarURL);
        }
        try {
            PhysicalZipFile physicalZipFile;
            block17: {
                InputStream inputStream = url.openStream();
                try {
                    PhysicalZipFile physicalZipFile2 = null;
                    try {
                        File tempFile = this.makeTempFile(jarURL, true);
                        Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        if (subLog != null) {
                            subLog.log("Downloaded jar to temporary file " + tempFile);
                        }
                        physicalZipFile2 = this.canonicalFileToPhysicalZipFile(tempFile, log);
                        this.additionalAllocatedPhysicalZipFiles.add(physicalZipFile2);
                    }
                    catch (IOException | SecurityException | UnsupportedOperationException e) {
                        if (log != null) {
                            log.log("Could not download jar to temp file (" + e + "), downloading to ByteBuffer instead");
                        }
                        ByteBuffer byteBuffer = FileUtils.readAllBytesAsByteBuffer(inputStream, -1L);
                        physicalZipFile2 = new PhysicalZipFile(byteBuffer, null, jarURL, this);
                    }
                    if (physicalZipFile2 == null) {
                        throw ClassGraphException.newClassGraphException("physicalZipFile should not be null");
                    }
                    physicalZipFile = physicalZipFile2;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return physicalZipFile;
        }
        finally {
            if (subLog != null) {
                subLog.addElapsedTime();
                subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
            }
        }
    }

    public void close(LogNode log) {
        if (!this.closed.getAndSet(true)) {
            Object logicalZipFile;
            if (this.inflaterRecycler != null) {
                this.inflaterRecycler.forceClose();
                this.inflaterRecycler = null;
            }
            if (this.moduleRefToModuleReaderProxyRecyclerMap != null) {
                try {
                    for (Recycler<ModuleReaderProxy, IOException> recycler : this.moduleRefToModuleReaderProxyRecyclerMap.values()) {
                        recycler.forceClose();
                    }
                }
                catch (InterruptedException e) {
                    this.interruptionChecker.interrupt();
                }
                this.moduleRefToModuleReaderProxyRecyclerMap.clear();
                this.moduleRefToModuleReaderProxyRecyclerMap = null;
            }
            if (this.zipFileSliceToLogicalZipFileMap != null) {
                this.zipFileSliceToLogicalZipFileMap.clear();
                this.zipFileSliceToLogicalZipFileMap = null;
            }
            if (this.nestedPathToLogicalZipFileAndPackageRootMap != null) {
                this.nestedPathToLogicalZipFileAndPackageRootMap.clear();
                this.nestedPathToLogicalZipFileAndPackageRootMap = null;
            }
            while ((logicalZipFile = this.allocatedLogicalZipFiles.poll()) != null) {
                ((LogicalZipFile)logicalZipFile).close();
            }
            if (this.canonicalFileToPhysicalZipFileMap != null) {
                try {
                    for (PhysicalZipFile physicalZipFile : this.canonicalFileToPhysicalZipFileMap.values()) {
                        physicalZipFile.close();
                    }
                }
                catch (InterruptedException e) {
                    this.interruptionChecker.interrupt();
                }
                this.canonicalFileToPhysicalZipFileMap.clear();
                this.canonicalFileToPhysicalZipFileMap = null;
            }
            if (this.additionalAllocatedPhysicalZipFiles != null) {
                PhysicalZipFile physicalZipFile;
                while ((physicalZipFile = this.additionalAllocatedPhysicalZipFiles.poll()) != null) {
                    physicalZipFile.close();
                }
                this.additionalAllocatedPhysicalZipFiles.clear();
                this.additionalAllocatedPhysicalZipFiles = null;
            }
            if (this.fastZipEntryToZipFileSliceMap != null) {
                this.fastZipEntryToZipFileSliceMap.clear();
                this.fastZipEntryToZipFileSliceMap = null;
            }
            if (this.tempFiles != null) {
                LogNode rmLog;
                LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
                while (!this.tempFiles.isEmpty()) {
                    File tempFile = this.tempFiles.removeLast();
                    try {
                        Files.delete(tempFile.toPath());
                    }
                    catch (IOException | SecurityException e) {
                        if (rmLog == null) continue;
                        rmLog.log("Removing temporary file failed: " + e);
                    }
                }
                this.tempFiles.clear();
                this.tempFiles = null;
            }
        }
    }
}

