/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;

@RelocatedClass
@Generated
@SuppressFBWarnings
class ZipFileSliceReader
implements AutoCloseable {
    private final ZipFileSlice zipFileSlice;
    private final ByteBuffer[] chunkCache;
    private final byte[] scratch = new byte[256];

    public ZipFileSliceReader(ZipFileSlice zipFileSlice) {
        this.zipFileSlice = zipFileSlice;
        this.chunkCache = new ByteBuffer[zipFileSlice.physicalZipFile.numMappedByteBuffers];
    }

    private ByteBuffer getChunk(int chunkIdx) throws IOException, InterruptedException {
        ByteBuffer chunk = this.chunkCache[chunkIdx];
        if (chunk == null) {
            ByteBuffer byteBufferDup;
            chunk = this.chunkCache[chunkIdx] = (byteBufferDup = this.zipFileSlice.physicalZipFile.getByteBuffer(chunkIdx).duplicate());
        }
        return chunk;
    }

    int read(long off, byte[] buf, int bufStart, int numBytesToRead) throws IOException, InterruptedException {
        int numBytesRead;
        if (off < 0L || bufStart < 0 || bufStart + numBytesToRead > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int currBufStart = bufStart;
        int totBytesRead = 0;
        long currOff = off;
        for (int remainingBytesToRead = numBytesToRead; remainingBytesToRead > 0; remainingBytesToRead -= numBytesRead) {
            long currOffAbsolute = this.zipFileSlice.startOffsetWithinPhysicalZipFile + currOff;
            int chunkIdx = (int)(currOffAbsolute / 0x7FFFFFF7L);
            ByteBuffer chunk = this.getChunk(chunkIdx);
            long chunkStartAbsolute = (long)chunkIdx * 0x7FFFFFF7L;
            int startReadPos = (int)(currOffAbsolute - chunkStartAbsolute);
            ((Buffer)chunk).mark();
            ((Buffer)chunk).position(startReadPos);
            numBytesRead = Math.min(chunk.remaining(), remainingBytesToRead);
            try {
                chunk.get(buf, currBufStart, numBytesRead);
            }
            catch (BufferUnderflowException e) {
                throw new EOFException("Unexpected EOF");
            }
            ((Buffer)chunk).reset();
            currOff += (long)numBytesRead;
            currBufStart += numBytesRead;
            totBytesRead += numBytesRead;
        }
        return totBytesRead == 0 && numBytesToRead > 0 ? -1 : totBytesRead;
    }

    static int getShort(byte[] arr, long off) throws IndexOutOfBoundsException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > arr.length - 2) {
            throw new IndexOutOfBoundsException();
        }
        return (arr[ioff + 1] & 0xFF) << 8 | arr[ioff] & 0xFF;
    }

    int getShort(long off) throws IOException, InterruptedException {
        if (off < 0L || off > this.zipFileSlice.len - 2L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.scratch, 0, 2) < 2) {
            throw new EOFException("Unexpected EOF");
        }
        return (this.scratch[1] & 0xFF) << 8 | this.scratch[0] & 0xFF;
    }

    static int getInt(byte[] arr, long off) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > arr.length - 4) {
            throw new IndexOutOfBoundsException();
        }
        return (arr[ioff + 3] & 0xFF) << 24 | (arr[ioff + 2] & 0xFF) << 16 | (arr[ioff + 1] & 0xFF) << 8 | arr[ioff] & 0xFF;
    }

    int getInt(long off) throws IOException, InterruptedException {
        if (off < 0L || off > this.zipFileSlice.len - 4L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.scratch, 0, 4) < 4) {
            throw new EOFException("Unexpected EOF");
        }
        return (this.scratch[3] & 0xFF) << 24 | (this.scratch[2] & 0xFF) << 16 | (this.scratch[1] & 0xFF) << 8 | this.scratch[0] & 0xFF;
    }

    static long getLong(byte[] arr, long off) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > arr.length - 8) {
            throw new IndexOutOfBoundsException();
        }
        return ((long)arr[ioff + 7] & 0xFFL) << 56 | ((long)arr[ioff + 6] & 0xFFL) << 48 | ((long)arr[ioff + 5] & 0xFFL) << 40 | ((long)arr[ioff + 4] & 0xFFL) << 32 | ((long)arr[ioff + 3] & 0xFFL) << 24 | ((long)arr[ioff + 2] & 0xFFL) << 16 | ((long)arr[ioff + 1] & 0xFFL) << 8 | (long)arr[ioff] & 0xFFL;
    }

    long getLong(long off) throws IOException, InterruptedException {
        if (off < 0L || off > this.zipFileSlice.len - 8L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.scratch, 0, 8) < 8) {
            throw new EOFException("Unexpected EOF");
        }
        return ((long)this.scratch[7] & 0xFFL) << 56 | ((long)this.scratch[6] & 0xFFL) << 48 | ((long)this.scratch[5] & 0xFFL) << 40 | ((long)this.scratch[4] & 0xFFL) << 32 | ((long)this.scratch[3] & 0xFFL) << 24 | ((long)this.scratch[2] & 0xFFL) << 16 | ((long)this.scratch[1] & 0xFFL) << 8 | (long)this.scratch[0] & 0xFFL;
    }

    static String getString(byte[] arr, long off, int lenBytes) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > arr.length - lenBytes) {
            throw new IndexOutOfBoundsException();
        }
        return new String(arr, ioff, lenBytes, StandardCharsets.UTF_8);
    }

    String getString(long off, int lenBytes) throws IOException, InterruptedException {
        byte[] scratchToUse;
        if (off < 0L || off > this.zipFileSlice.len - (long)lenBytes) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = scratchToUse = lenBytes <= this.scratch.length ? this.scratch : new byte[lenBytes];
        if (this.read(off, scratchToUse, 0, lenBytes) < lenBytes) {
            throw new EOFException("Unexpected EOF");
        }
        return new String(scratchToUse, 0, lenBytes, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
        Arrays.fill(this.chunkCache, null);
    }
}

