/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class InputStreamOrByteBufferAdapter
implements AutoCloseable {
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    private InputStream inputStream;
    private ByteBuffer byteBuffer;
    public byte[] buf;
    public int curr;
    private int used;

    public InputStreamOrByteBufferAdapter(InputStream inputStream) {
        this.inputStream = inputStream;
        this.buf = new byte[16384];
    }

    public InputStreamOrByteBufferAdapter(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.buf = byteBuffer.array();
        } else {
            this.byteBuffer = byteBuffer;
            this.buf = new byte[16384];
        }
    }

    private int read(int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.inputStream != null) {
            return this.inputStream.read(this.buf, off, len);
        }
        int bytesRemainingInBuf = this.byteBuffer != null ? this.byteBuffer.remaining() : this.buf.length - off;
        int bytesRead = Math.max(0, Math.min(len, bytesRemainingInBuf));
        if (bytesRead == 0) {
            return -1;
        }
        if (this.byteBuffer != null) {
            int byteBufPositionBefore = this.byteBuffer.position();
            try {
                this.byteBuffer.get(this.buf, off, bytesRead);
            }
            catch (BufferUnderflowException e) {
                throw new IOException("Buffer underflow", e);
            }
            return this.byteBuffer.position() - byteBufPositionBefore;
        }
        return bytesRead;
    }

    private void readMore(int bytesRequired) throws IOException {
        int bytesRead;
        if ((long)this.used + (long)bytesRequired > 0x7FFFFFF7L) {
            throw new IOException("File is larger than 2GB, cannot read it");
        }
        int targetReadSize = Math.max(bytesRequired, this.used == 0 ? 16384 : 4096);
        int maxNewUsed = (int)Math.min((long)this.used + (long)targetReadSize, 0x7FFFFFF7L);
        int bytesToRead = maxNewUsed - this.used;
        if (maxNewUsed > this.buf.length) {
            long newBufLen;
            for (newBufLen = (long)this.buf.length; newBufLen < (long)maxNewUsed; newBufLen <<= 1) {
            }
            this.buf = Arrays.copyOf(this.buf, (int)Math.min(newBufLen, 0x7FFFFFF7L));
        }
        int totBytesRead = 0;
        for (int extraBytesStillNotRead = bytesToRead; extraBytesStillNotRead > 0 && (bytesRead = this.read(this.used, extraBytesStillNotRead)) > 0; extraBytesStillNotRead -= bytesRead) {
            this.used += bytesRead;
            totBytesRead += bytesRead;
        }
        if (totBytesRead < bytesRequired) {
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    public int readUnsignedByte() throws IOException {
        int val = this.readUnsignedByte(this.curr);
        ++this.curr;
        return val;
    }

    public int readUnsignedByte(int offset) throws IOException {
        int bytesToRead = Math.max(0, offset + 1 - this.used);
        if (bytesToRead > 0) {
            this.readMore(bytesToRead);
        }
        return this.buf[offset] & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        int val = this.readUnsignedShort(this.curr);
        this.curr += 2;
        return val;
    }

    public int readUnsignedShort(int offset) throws IOException {
        int bytesToRead = Math.max(0, offset + 2 - this.used);
        if (bytesToRead > 0) {
            this.readMore(bytesToRead);
        }
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    public int readInt() throws IOException {
        int val = this.readInt(this.curr);
        this.curr += 4;
        return val;
    }

    public int readInt(int offset) throws IOException {
        int bytesToRead = Math.max(0, offset + 4 - this.used);
        if (bytesToRead > 0) {
            this.readMore(bytesToRead);
        }
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    public long readLong() throws IOException {
        long val = this.readLong(this.curr);
        this.curr += 8;
        return val;
    }

    public long readLong(int offset) throws IOException {
        int bytesToRead = Math.max(0, offset + 8 - this.used);
        if (bytesToRead > 0) {
            this.readMore(bytesToRead);
        }
        return ((long)this.buf[offset] & 0xFFL) << 56 | ((long)this.buf[offset + 1] & 0xFFL) << 48 | ((long)this.buf[offset + 2] & 0xFFL) << 40 | ((long)this.buf[offset + 3] & 0xFFL) << 32 | ((long)this.buf[offset + 4] & 0xFFL) << 24 | ((long)this.buf[offset + 5] & 0xFFL) << 16 | ((long)this.buf[offset + 6] & 0xFFL) << 8 | (long)this.buf[offset + 7] & 0xFFL;
    }

    public void skip(int bytesToSkip) throws IOException {
        int bytesToRead = Math.max(0, this.curr + bytesToSkip - this.used);
        if (bytesToRead > 0) {
            this.readMore(bytesToRead);
        }
        this.curr += bytesToSkip;
    }

    public String readString(int strStart, boolean replaceSlashWithDot, boolean stripLSemicolon) throws IOException {
        int c;
        int byteIdx;
        int utfStart = strStart + 2;
        int utfLen = this.readUnsignedShort(strStart);
        int bufferUnderrunBytes = Math.max(0, utfStart + utfLen - this.used);
        if (bufferUnderrunBytes > 0) {
            this.readMore(bufferUnderrunBytes);
        }
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[utfStart + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[utfStart + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new IOException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new IOException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new IOException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 2];
                    byte c3 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IOException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new IOException("Bad modified UTF8");
        }
        if (charIdx == utfLen && !stripLSemicolon) {
            return new String(chars);
        }
        if (stripLSemicolon) {
            if (charIdx < 2 || chars[0] != 'L' || chars[charIdx - 1] != ';') {
                throw new IOException("Expected string to start with 'L' and end with ';', got \"" + new String(chars) + "\"");
            }
            return new String(chars, 1, charIdx - 2);
        }
        return new String(chars, 0, charIdx);
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
        this.byteBuffer = null;
        this.buf = null;
    }
}

