/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.nonapi.io.github.classgraph.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class URLPathEncoder {
    private static boolean[] safe;
    private static final char[] HEXADECIMAL;
    private static final String[] SCHEME_PREFIXES;

    private URLPathEncoder() {
    }

    public static String encodePath(String path) {
        int validColonPrefixLen = 0;
        for (String scheme : SCHEME_PREFIXES) {
            if (!path.startsWith(scheme)) continue;
            validColonPrefixLen = scheme.length();
            break;
        }
        byte[] pathBytes = path.getBytes(StandardCharsets.UTF_8);
        StringBuilder encodedPath = new StringBuilder(pathBytes.length * 3);
        for (int i2 = 0; i2 < pathBytes.length; ++i2) {
            byte pathByte = pathBytes[i2];
            int b = pathByte & 0xFF;
            if (safe[b] || b == 58 && i2 < validColonPrefixLen) {
                encodedPath.append((char)b);
                continue;
            }
            encodedPath.append('%');
            encodedPath.append(HEXADECIMAL[(b & 0xF0) >> 4]);
            encodedPath.append(HEXADECIMAL[b & 0xF]);
        }
        return encodedPath.toString();
    }

    public static String normalizeURLPath(String urlPath) {
        String urlPathNormalized = urlPath;
        if (!(urlPathNormalized.startsWith("jrt:") || urlPathNormalized.startsWith("http://") || urlPathNormalized.startsWith("https://"))) {
            if (!(urlPathNormalized = urlPathNormalized.replace("/!", "!").replace("!/", "!").replace("!", "!/")).startsWith("file:") && !urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = "file:" + urlPathNormalized;
            }
            if (urlPathNormalized.contains("!") && !urlPathNormalized.startsWith("jar:")) {
                urlPathNormalized = "jar:" + urlPathNormalized;
            }
        }
        return URLPathEncoder.encodePath(urlPathNormalized);
    }

    static {
        int i2;
        safe = new boolean[256];
        for (i2 = 97; i2 <= 122; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            URLPathEncoder.safe[i2] = true;
        }
        URLPathEncoder.safe[43] = true;
        URLPathEncoder.safe[46] = true;
        URLPathEncoder.safe[95] = true;
        URLPathEncoder.safe[45] = true;
        URLPathEncoder.safe[36] = true;
        URLPathEncoder.safe[44] = true;
        URLPathEncoder.safe[41] = true;
        URLPathEncoder.safe[40] = true;
        URLPathEncoder.safe[39] = true;
        URLPathEncoder.safe[42] = true;
        URLPathEncoder.safe[33] = true;
        URLPathEncoder.safe[47] = true;
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        SCHEME_PREFIXES = new String[]{"jrt:", "file:", "jar:file:", "jar:", "http:", "https:"};
    }
}

