/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.Unit;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.okhttp3.RequestBody;
import name.remal.gradle_plugins.internal._relocated.okhttp3.ResponseBody;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Retrofit;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Utils;
import name.remal.gradle_plugins.internal._relocated.retrofit2.http.Streaming;

@RelocatedClass
@Generated
@SuppressFBWarnings
final class BuiltInConverters
extends Converter.Factory {
    private boolean checkForKotlinUnit = true;

    BuiltInConverters() {
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations2, Retrofit retrofit) {
        if (type == ResponseBody.class) {
            return Utils.isAnnotationPresent(annotations2, Streaming.class) ? StreamingResponseBodyConverter.INSTANCE : BufferingResponseBodyConverter.INSTANCE;
        }
        if (type == Void.class) {
            return VoidResponseBodyConverter.INSTANCE;
        }
        if (this.checkForKotlinUnit) {
            try {
                if (type == Unit.class) {
                    return UnitResponseBodyConverter.INSTANCE;
                }
            }
            catch (NoClassDefFoundError ignored) {
                this.checkForKotlinUnit = false;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (RequestBody.class.isAssignableFrom(Utils.getRawType(type))) {
            return RequestBodyConverter.INSTANCE;
        }
        return null;
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class ToStringConverter
    implements Converter<Object, String> {
        static final ToStringConverter INSTANCE = new ToStringConverter();

        ToStringConverter() {
        }

        @Override
        public String convert(Object value) {
            return value.toString();
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class BufferingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final BufferingResponseBodyConverter INSTANCE = new BufferingResponseBodyConverter();

        BufferingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody value) throws IOException {
            try {
                ResponseBody responseBody = Utils.buffer(value);
                return responseBody;
            }
            finally {
                value.close();
            }
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class StreamingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final StreamingResponseBodyConverter INSTANCE = new StreamingResponseBodyConverter();

        StreamingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody value) {
            return value;
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class RequestBodyConverter
    implements Converter<RequestBody, RequestBody> {
        static final RequestBodyConverter INSTANCE = new RequestBodyConverter();

        RequestBodyConverter() {
        }

        @Override
        public RequestBody convert(RequestBody value) {
            return value;
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class UnitResponseBodyConverter
    implements Converter<ResponseBody, Unit> {
        static final UnitResponseBodyConverter INSTANCE = new UnitResponseBodyConverter();

        UnitResponseBodyConverter() {
        }

        @Override
        public Unit convert(ResponseBody value) {
            value.close();
            return Unit.INSTANCE;
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static final class VoidResponseBodyConverter
    implements Converter<ResponseBody, Void> {
        static final VoidResponseBodyConverter INSTANCE = new VoidResponseBodyConverter();

        VoidResponseBodyConverter() {
        }

        @Override
        public Void convert(ResponseBody value) {
            value.close();
            return null;
        }
    }
}

