/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CallAdapter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CompletableFutureCallAdapterFactory;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.DefaultCallAdapterFactory;
import name.remal.gradle_plugins.internal._relocated.retrofit2.OptionalConverterFactory;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@RelocatedClass
@Generated
@SuppressFBWarnings
class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("java.util.Optional");
            return new Java8();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Platform();
        }
    }

    @Nullable
    Executor defaultCallbackExecutor() {
        return null;
    }

    List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
        return Collections.singletonList(new DefaultCallAdapterFactory(callbackExecutor));
    }

    int defaultCallAdapterFactoriesSize() {
        return 1;
    }

    List<? extends Converter.Factory> defaultConverterFactories() {
        return Collections.emptyList();
    }

    int defaultConverterFactoriesSize() {
        return 0;
    }

    boolean isDefaultMethod(Method method) {
        return false;
    }

    @Nullable
    Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
        throw new UnsupportedOperationException();
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class Android
    extends Platform {
        Android() {
        }

        @Override
        @IgnoreJRERequirement
        boolean isDefaultMethod(Method method) {
            if (Build.VERSION.SDK_INT < 24) {
                return false;
            }
            return method.isDefault();
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
            if (callbackExecutor == null) {
                throw new AssertionError();
            }
            DefaultCallAdapterFactory executorFactory = new DefaultCallAdapterFactory(callbackExecutor);
            return Build.VERSION.SDK_INT >= 24 ? Arrays.asList(CompletableFutureCallAdapterFactory.INSTANCE, executorFactory) : Collections.singletonList(executorFactory);
        }

        @Override
        int defaultCallAdapterFactoriesSize() {
            return Build.VERSION.SDK_INT >= 24 ? 2 : 1;
        }

        @Override
        List<? extends Converter.Factory> defaultConverterFactories() {
            return Build.VERSION.SDK_INT >= 24 ? Collections.singletonList(OptionalConverterFactory.INSTANCE) : Collections.emptyList();
        }

        @Override
        int defaultConverterFactoriesSize() {
            return Build.VERSION.SDK_INT >= 24 ? 1 : 0;
        }

        @RelocatedClass
        @Generated
        @SuppressFBWarnings
        static class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                this.handler.post(r);
            }
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    @IgnoreJRERequirement
    static class Java8
    extends Platform {
        Java8() {
        }

        @Override
        boolean isDefaultMethod(Method method) {
            return method.isDefault();
        }

        @Override
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, -1)).unreflectSpecial(method, declaringClass).bindTo(object).invokeWithArguments(args);
        }

        @Override
        List<? extends CallAdapter.Factory> defaultCallAdapterFactories(@Nullable Executor callbackExecutor) {
            ArrayList<CallAdapter.Factory> factories = new ArrayList<CallAdapter.Factory>(2);
            factories.add(CompletableFutureCallAdapterFactory.INSTANCE);
            factories.add(new DefaultCallAdapterFactory(callbackExecutor));
            return Collections.unmodifiableList(factories);
        }

        @Override
        int defaultCallAdapterFactoriesSize() {
            return 2;
        }

        @Override
        List<? extends Converter.Factory> defaultConverterFactories() {
            return Collections.singletonList(OptionalConverterFactory.INSTANCE);
        }

        @Override
        int defaultConverterFactoriesSize() {
            return 1;
        }
    }
}

