/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.internal._relocated.okhttp3.Call;
import name.remal.gradle_plugins.internal._relocated.okhttp3.HttpUrl;
import name.remal.gradle_plugins.internal._relocated.okhttp3.OkHttpClient;
import name.remal.gradle_plugins.internal._relocated.okhttp3.RequestBody;
import name.remal.gradle_plugins.internal._relocated.okhttp3.ResponseBody;
import name.remal.gradle_plugins.internal._relocated.retrofit2.BuiltInConverters;
import name.remal.gradle_plugins.internal._relocated.retrofit2.CallAdapter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Platform;
import name.remal.gradle_plugins.internal._relocated.retrofit2.ServiceMethod;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Utils;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class Retrofit {
    private final Map<Method, ServiceMethod<?>> serviceMethodCache = new ConcurrentHashMap();
    final Call.Factory callFactory;
    final HttpUrl baseUrl;
    final List<Converter.Factory> converterFactories;
    final List<CallAdapter.Factory> callAdapterFactories;
    @Nullable
    final Executor callbackExecutor;
    final boolean validateEagerly;

    Retrofit(Call.Factory callFactory, HttpUrl baseUrl, List<Converter.Factory> converterFactories, List<CallAdapter.Factory> callAdapterFactories, @Nullable Executor callbackExecutor, boolean validateEagerly) {
        this.callFactory = callFactory;
        this.baseUrl = baseUrl;
        this.converterFactories = converterFactories;
        this.callAdapterFactories = callAdapterFactories;
        this.callbackExecutor = callbackExecutor;
        this.validateEagerly = validateEagerly;
    }

    public <T> T create(final Class<T> service2) {
        Utils.validateServiceInterface(service2);
        if (this.validateEagerly) {
            this.eagerlyValidateMethods(service2);
        }
        return (T)Proxy.newProxyInstance(service2.getClassLoader(), new Class[]{service2}, new InvocationHandler(){
            private final Platform platform = Platform.get();
            private final Object[] emptyArgs = new Object[0];

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                if (this.platform.isDefaultMethod(method)) {
                    return this.platform.invokeDefaultMethod(method, service2, proxy, args);
                }
                return Retrofit.this.loadServiceMethod(method).invoke(args != null ? args : this.emptyArgs);
            }
        });
    }

    private void eagerlyValidateMethods(Class<?> service2) {
        Platform platform = Platform.get();
        for (Method method : service2.getDeclaredMethods()) {
            if (platform.isDefaultMethod(method) || Modifier.isStatic(method.getModifiers())) continue;
            this.loadServiceMethod(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceMethod<?> loadServiceMethod(Method method) {
        ServiceMethod<Object> result2 = this.serviceMethodCache.get(method);
        if (result2 != null) {
            return result2;
        }
        Map<Method, ServiceMethod<?>> map = this.serviceMethodCache;
        synchronized (map) {
            result2 = this.serviceMethodCache.get(method);
            if (result2 == null) {
                result2 = ServiceMethod.parseAnnotations(this, method);
                this.serviceMethodCache.put(method, result2);
            }
        }
        return result2;
    }

    public Call.Factory callFactory() {
        return this.callFactory;
    }

    public HttpUrl baseUrl() {
        return this.baseUrl;
    }

    public List<CallAdapter.Factory> callAdapterFactories() {
        return this.callAdapterFactories;
    }

    public CallAdapter<?, ?> callAdapter(Type returnType, Annotation[] annotations2) {
        return this.nextCallAdapter(null, returnType, annotations2);
    }

    public CallAdapter<?, ?> nextCallAdapter(@Nullable CallAdapter.Factory skipPast, Type returnType, Annotation[] annotations2) {
        int i2;
        int start;
        Utils.checkNotNull(returnType, "returnType == null");
        Utils.checkNotNull(annotations2, "annotations == null");
        int count = this.callAdapterFactories.size();
        for (int i3 = start = this.callAdapterFactories.indexOf(skipPast) + 1; i3 < count; ++i3) {
            CallAdapter<?, ?> adapter = this.callAdapterFactories.get(i3).get(returnType, annotations2, this);
            if (adapter == null) continue;
            return adapter;
        }
        StringBuilder builder = new StringBuilder("Could not locate call adapter for ").append(returnType).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i2 = 0; i2 < start; ++i2) {
                builder.append("\n   * ").append(this.callAdapterFactories.get(i2).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.callAdapterFactories.size();
        for (i2 = start; i2 < count2; ++i2) {
            builder.append("\n   * ").append(this.callAdapterFactories.get(i2).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public List<Converter.Factory> converterFactories() {
        return this.converterFactories;
    }

    public <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        return this.nextRequestBodyConverter(null, type, parameterAnnotations, methodAnnotations);
    }

    public <T> Converter<T, RequestBody> nextRequestBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        int i2;
        int start;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(parameterAnnotations, "parameterAnnotations == null");
        Utils.checkNotNull(methodAnnotations, "methodAnnotations == null");
        int count = this.converterFactories.size();
        for (int i3 = start = this.converterFactories.indexOf(skipPast) + 1; i3 < count; ++i3) {
            Converter.Factory factory = this.converterFactories.get(i3);
            Converter<?, RequestBody> converter = factory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate RequestBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i2 = 0; i2 < start; ++i2) {
                builder.append("\n   * ").append(this.converterFactories.get(i2).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i2 = start; i2 < count2; ++i2) {
            builder.append("\n   * ").append(this.converterFactories.get(i2).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<ResponseBody, T> responseBodyConverter(Type type, Annotation[] annotations2) {
        return this.nextResponseBodyConverter(null, type, annotations2);
    }

    public <T> Converter<ResponseBody, T> nextResponseBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] annotations2) {
        int i2;
        int start;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations2, "annotations == null");
        int count = this.converterFactories.size();
        for (int i3 = start = this.converterFactories.indexOf(skipPast) + 1; i3 < count; ++i3) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i3).responseBodyConverter(type, annotations2, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate ResponseBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i2 = 0; i2 < start; ++i2) {
                builder.append("\n   * ").append(this.converterFactories.get(i2).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i2 = start; i2 < count2; ++i2) {
            builder.append("\n   * ").append(this.converterFactories.get(i2).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<T, String> stringConverter(Type type, Annotation[] annotations2) {
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations2, "annotations == null");
        int count = this.converterFactories.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Converter<?, String> converter = this.converterFactories.get(i2).stringConverter(type, annotations2, this);
            if (converter == null) continue;
            return converter;
        }
        return BuiltInConverters.ToStringConverter.INSTANCE;
    }

    @Nullable
    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    public static final class Builder {
        private final Platform platform;
        @Nullable
        private Call.Factory callFactory;
        @Nullable
        private HttpUrl baseUrl;
        private final List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private final List<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        @Nullable
        private Executor callbackExecutor;
        private boolean validateEagerly;

        Builder(Platform platform) {
            this.platform = platform;
        }

        public Builder() {
            this(Platform.get());
        }

        Builder(Retrofit retrofit) {
            int i2;
            this.platform = Platform.get();
            this.callFactory = retrofit.callFactory;
            this.baseUrl = retrofit.baseUrl;
            int size = retrofit.converterFactories.size() - this.platform.defaultConverterFactoriesSize();
            for (i2 = 1; i2 < size; ++i2) {
                this.converterFactories.add(retrofit.converterFactories.get(i2));
            }
            size = retrofit.callAdapterFactories.size() - this.platform.defaultCallAdapterFactoriesSize();
            for (i2 = 0; i2 < size; ++i2) {
                this.callAdapterFactories.add(retrofit.callAdapterFactories.get(i2));
            }
            this.callbackExecutor = retrofit.callbackExecutor;
            this.validateEagerly = retrofit.validateEagerly;
        }

        public Builder client(OkHttpClient client2) {
            return this.callFactory(Utils.checkNotNull(client2, "client == null"));
        }

        public Builder callFactory(Call.Factory factory) {
            this.callFactory = Utils.checkNotNull(factory, "factory == null");
            return this;
        }

        public Builder baseUrl(URL baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(baseUrl.toString()));
        }

        public Builder baseUrl(String baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(baseUrl));
        }

        public Builder baseUrl(HttpUrl baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            List<String> pathSegments = baseUrl.pathSegments();
            if (!"".equals(pathSegments.get(pathSegments.size() - 1))) {
                throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder addConverterFactory(Converter.Factory factory) {
            this.converterFactories.add(Utils.checkNotNull(factory, "factory == null"));
            return this;
        }

        public Builder addCallAdapterFactory(CallAdapter.Factory factory) {
            this.callAdapterFactories.add(Utils.checkNotNull(factory, "factory == null"));
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.callbackExecutor = Utils.checkNotNull(executor, "executor == null");
            return this;
        }

        public List<CallAdapter.Factory> callAdapterFactories() {
            return this.callAdapterFactories;
        }

        public List<Converter.Factory> converterFactories() {
            return this.converterFactories;
        }

        public Builder validateEagerly(boolean validateEagerly) {
            this.validateEagerly = validateEagerly;
            return this;
        }

        public Retrofit build() {
            Executor callbackExecutor;
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((callbackExecutor = this.callbackExecutor) == null) {
                callbackExecutor = this.platform.defaultCallbackExecutor();
            }
            ArrayList<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>(this.callAdapterFactories);
            callAdapterFactories.addAll(this.platform.defaultCallAdapterFactories(callbackExecutor));
            ArrayList<? extends Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(1 + this.converterFactories.size() + this.platform.defaultConverterFactoriesSize());
            converterFactories.add(new BuiltInConverters());
            converterFactories.addAll(this.converterFactories);
            converterFactories.addAll(this.platform.defaultConverterFactories());
            return new Retrofit(callFactory, this.baseUrl, Collections.unmodifiableList(converterFactories), Collections.unmodifiableList(callAdapterFactories), callbackExecutor, this.validateEagerly);
        }
    }
}

