/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.ci;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import name.remal.DefaultKt;
import name.remal.Java_io_FileKt;
import name.remal.Kotlin_CharSequenceKt;
import name.remal.gradle_plugins.dsl.EnvironmentVariable;
import name.remal.gradle_plugins.dsl.Plugin;
import name.remal.gradle_plugins.dsl.PluginAction;
import name.remal.gradle_plugins.dsl.PluginActionsGroup;
import name.remal.gradle_plugins.dsl.PluginCondition;
import name.remal.gradle_plugins.dsl.WithPluginClasses;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_ProjectKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_plugins_ExtensionContainerKt;
import name.remal.gradle_plugins.plugins.ci.BaseCIPlugin;
import name.remal.gradle_plugins.plugins.ci.CIExtension;
import name.remal.gradle_plugins.plugins.ci.GitlabCIPlugin;
import name.remal.gradle_plugins.plugins.environment_variables.EnvironmentVariablesPlugin;
import name.remal.gradle_plugins.plugins.vcs.CommitAuthor;
import name.remal.gradle_plugins.plugins.vcs.VcsOperations;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsCustomizer;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsExtension;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsPlugin;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Plugin(id="name.remal.gitlab-ci", description="Plugin that helps to integrate with GitLab CI.", tags={"gitlab-ci", "gitlab"})
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0017J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin;", "Lname/remal/gradle_plugins/plugins/ci/BaseCIPlugin;", "()V", "Check if GITLAB_CI == 'true'", "", "Lorg/gradle/api/Project;", "Set 'ci' extension values", "", "Lorg/gradle/api/plugins/ExtensionContainer;", "ConfigureVcsOperationsPlugin", "gradle-plugins"})
public class GitlabCIPlugin
extends BaseCIPlugin {
    @PluginCondition
    public boolean Check if GITLAB_CI == 'true'(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Org_gradle_api_ProjectKt.applyPlugin((Project)$receiver, EnvironmentVariablesPlugin.class);
        return Intrinsics.areEqual((Object)System.getenv("GITLAB_CI"), (Object)"true");
    }

    @PluginAction(order=-1)
    public void Set 'ci' extension values(@NotNull ExtensionContainer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = Org_gradle_api_plugins_ExtensionContainerKt.get((ExtensionContainer)$receiver, CIExtension.class);
        CIExtension $receiver2 = (CIExtension)object;
        $receiver2.setPipelineId(null);
        $receiver2.setBuildId((String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)System.getenv("CI_PIPELINE_ID")));
        $receiver2.setStageName((String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)System.getenv("CI_JOB_STAGE")));
        $receiver2.setJobName((String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)System.getenv("CI_JOB_NAME")));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @PluginActionsGroup(value="Configure name.remal.vcs-operations plugin")
    @WithPluginClasses(value={VcsOperationsPlugin.class})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007J\u0014\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\f\u0010\t\u001a\u00020\u0004*\u00020\u0007H\u0007\u00a8\u0006\n"}, d2={"Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin$ConfigureVcsOperationsPlugin;", "", "(Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin;)V", "Add GitLab VcsOperationsCustomizer", "", "Lorg/gradle/api/invocation/Gradle;", "Setup VCS remote URI if SSH_PRIVATE_KEY environment variable is set", "Lorg/gradle/api/plugins/ExtensionContainer;", "gradle", "setOverwriteCurrentBranch", "gradle-plugins"})
    public final class ConfigureVcsOperationsPlugin {
        final /* synthetic */ GitlabCIPlugin this$0;

        @PluginAction(value="vcsOperations.overwriteCurrentBranch = getenv('CI_COMMIT_REF_NAME')")
        public final void setOverwriteCurrentBranch(@NotNull ExtensionContainer $receiver) {
            block0: {
                String string;
                String refName;
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                String string2 = System.getenv("CI_COMMIT_REF_NAME");
                if (string2 == null || !((charSequence = (CharSequence)(refName = (string = string2))).length() > 0) || !((charSequence = (CharSequence)System.getenv("CI_COMMIT_TAG")) == null || charSequence.length() == 0)) break block0;
                ((VcsOperationsExtension)Org_gradle_api_plugins_ExtensionContainerKt.get((ExtensionContainer)$receiver, VcsOperationsExtension.class)).setOverwriteCurrentBranch(refName);
            }
        }

        @PluginAction
        @EnvironmentVariable.EnvironmentVariables(value={@EnvironmentVariable(value="SSH_PRIVATE_KEY", description="SSH private key to push into repository"), @EnvironmentVariable(value="SSH_PRIVATE_KEY_FILE", description="SSH private key file path to push into repository"), @EnvironmentVariable(value="SSH_PRIVATE_KEY_PASSWORD", description="SSH private key password to push into repository")})
        public final void Setup VCS remote URI if SSH_PRIVATE_KEY environment variable is set(@NotNull ExtensionContainer $receiver, @NotNull Gradle gradle) {
            File file;
            String string;
            CharSequence charSequence;
            ExtensionContainer extensionContainer;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            VcsOperationsExtension vcsOperations2 = (VcsOperationsExtension)Org_gradle_api_plugins_ExtensionContainerKt.get((ExtensionContainer)$receiver, VcsOperationsExtension.class);
            ExtensionContainer $receiver2 = extensionContainer = $receiver;
            String string2 = System.getenv("SSH_PRIVATE_KEY_FILE");
            if (string2 != null) {
                charSequence = string2;
                String string3 = charSequence;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = null;
            }
            String sshPrivateKeyFilePath = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)string);
            if (sshPrivateKeyFilePath != null) {
                file = new File(sshPrivateKeyFilePath).getAbsoluteFile();
            } else {
                String string4;
                String string5 = System.getenv("SSH_PRIVATE_KEY");
                if (string5 != null) {
                    String string6;
                    String string7 = string6 = string5;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string4 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                } else {
                    string4 = null;
                }
                String sshPrivateKey = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)string4);
                if (sshPrivateKey != null) {
                    File file2;
                    File sshKeysDir = Java_io_FileKt.allowAllOnlyForOwner((File)Java_io_FileKt.createDirectories((File)FilesKt.resolve((File)Java_io_FileKt.getUSER_HOME_DIR(), (String)".ssh-keys")));
                    File it = file2 = Java_io_FileKt.forbidExecute((File)Java_io_FileKt.allowAllOnlyForOwner((File)Java_io_FileKt.newTempFile$default(null, (String)".priv", (boolean)false, (File)sshKeysDir, (int)5, null)));
                    gradle.buildFinished((Action)new Action<BuildResult>(it){
                        final /* synthetic */ File $it;

                        public final void execute(BuildResult $noName_0) {
                            FilesKt.deleteRecursively((File)this.$it);
                        }
                        {
                            this.$it = file;
                        }
                    });
                    it = file2;
                    FilesKt.writeText$default((File)it, (String)sshPrivateKey, null, (int)2, null);
                    file = file2;
                } else {
                    file = null;
                }
            }
            if (file == null) {
                return;
            }
            File sshPrivateKeyFile2 = file;
            String string8 = System.getenv("CI_REPOSITORY_URL");
            if (string8 == null) {
                return;
            }
            URI repositoryURI = new URI(string8);
            if (StringsKt.startsWith$default((String)DefaultKt.default$default((String)repositoryURI.getScheme(), null, (int)1, null), (String)"http", (boolean)false, (int)2, null)) {
                CharSequence $receiver3 = charSequence = new StringBuilder();
                ((StringBuilder)$receiver3).append("git@");
                ((StringBuilder)$receiver3).append(repositoryURI.getHost());
                ((StringBuilder)$receiver3).append(":");
                String string9 = repositoryURI.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"repositoryURI.path");
                ((StringBuilder)$receiver3).append(StringsKt.substringAfter$default((String)string9, (char)'/', null, (int)2, null));
                String string10 = ((StringBuilder)charSequence).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"StringBuilder().apply(builderAction).toString()");
                String remoteURI = string10;
                vcsOperations2.setUnauthorizedRemoteURI(remoteURI);
            }
            vcsOperations2.setSSHAuth(sshPrivateKeyFile2, System.getenv("SSH_PRIVATE_KEY_PASSWORD"));
        }

        @PluginAction
        public final void Add GitLab VcsOperationsCustomizer(@NotNull Gradle $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            VcsOperationsCustomizer customizer2 = new VcsOperationsCustomizer(){

                public void customize(@NotNull VcsOperations vcsOperations2) {
                    Intrinsics.checkParameterIsNotNull((Object)vcsOperations2, (String)"vcsOperations");
                    if (vcsOperations2.getCommitAuthor() == null) {
                        String string;
                        String string2;
                        String string3;
                        String string4;
                        String string5 = System.getenv("GITLAB_USER_NAME");
                        if (string5 != null) {
                            String string6 = string4 = string5;
                            if (string6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string3 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                        } else {
                            string3 = null;
                        }
                        if ((string2 = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)string3)) == null) {
                            String string7;
                            String string8 = System.getenv("GITLAB_USER_LOGIN");
                            if (string8 != null) {
                                String string9 = string4 = string8;
                                if (string9 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string7 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                            } else {
                                string7 = null;
                            }
                            string2 = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)string7);
                        }
                        String name = string2;
                        String string10 = System.getenv("GITLAB_USER_EMAIL");
                        if (string10 != null) {
                            String string11;
                            String string12 = string11 = string10;
                            if (string12 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string12)).toString();
                        } else {
                            string = null;
                        }
                        String email = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)string);
                        if (name != null || email != null) {
                            vcsOperations2.setCommitAuthor(new CommitAuthor(DefaultKt.default$default((String)name, null, (int)1, null), DefaultKt.default$default((String)email, null, (int)1, null)));
                        }
                    }
                }
            };
            VcsOperationsCustomizer.Companion.getVCS_OPERATIONS_CUSTOMIZERS().add(customizer2);
            $receiver.buildFinished((Action)new Action<BuildResult>(customizer2){
                final /* synthetic */ Add GitLab VcsOperationsCustomizer.customizer.1 $customizer;

                public final void execute(BuildResult it) {
                    VcsOperationsCustomizer.Companion.getVCS_OPERATIONS_CUSTOMIZERS().remove(this.$customizer);
                }
                {
                    this.$customizer = var1_1;
                }
            });
        }

        public ConfigureVcsOperationsPlugin(GitlabCIPlugin $outer) {
            this.this$0 = $outer;
        }

        @SuppressFBWarnings
        protected /* synthetic */ ConfigureVcsOperationsPlugin() {
        }
    }
}

