/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.classes_processing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import name.remal.Arrays_generatedKt;
import name.remal.ClasspathKt;
import name.remal.CollectionsKt;
import name.remal.Java_io_FileKt;
import name.remal.Java_util_concurrent_atomic_AtomicLongKt;
import name.remal.Java_util_stream_StreamKt;
import name.remal.ListBuilder;
import name.remal.Org_objectweb_asm_ClassReaderKt;
import name.remal.Services;
import name.remal.ServicesKt;
import name.remal.gradle_plugins.api.classes_processing.BytecodeModifier;
import name.remal.gradle_plugins.api.classes_processing.ClassesProcessor;
import name.remal.gradle_plugins.api.classes_processing.ClassesProcessorsGradleTaskFactory;
import name.remal.gradle_plugins.api.classes_processing.ProcessContext;
import name.remal.gradle_plugins.dsl.ApplyPluginClasses;
import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin;
import name.remal.gradle_plugins.dsl.Plugin;
import name.remal.gradle_plugins.dsl.PluginAction;
import name.remal.gradle_plugins.dsl.extensions.Kotlin_collections_Iterable_java_io_FileKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_DomainObjectCollectionKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_TaskKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_Task_logging_generatedKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_tasks_compile_AbstractCompileKt;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingFilter;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingFiltersFactory;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingPlugin;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingPlugin$setupClassesProcessing$1$4$1$$special$;
import name.remal.gradle_plugins.plugins.common.CommonSettingsPlugin;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;

@Plugin(id="name.remal.classes-processing", description="Plugin that adds ability to process *.class files. It executes all ClassesProcessor services for each compiled class file.", tags={"java"})
@ApplyPluginClasses(value={CommonSettingsPlugin.class})
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00072\u00020\u0001:\u0004\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin;", "Lname/remal/gradle_plugins/dsl/BaseReflectiveProjectPlugin;", "()V", "setupClassesProcessing", "", "Lorg/gradle/api/tasks/TaskContainer;", "BinaryContent", "Companion", "ProcessAction", "Timing", "gradle-plugins"})
public class ClassesProcessingPlugin
extends BaseReflectiveProjectPlugin {
    private static final List<ClassesProcessingFilter> classesProcessingFilters;
    private static final List<ClassesProcessingFiltersFactory> classesProcessingFiltersFactories;
    public static final Companion Companion;

    @PluginAction(isHidden=true)
    public void setupClassesProcessing(@NotNull TaskContainer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Org_gradle_api_DomainObjectCollectionKt.all((DomainObjectCollection)((DomainObjectCollection)$receiver), AbstractCompile.class, (Function1)((Function1)new Function1<AbstractCompile, Unit>($receiver){
            final /* synthetic */ TaskContainer receiver$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AbstractCompile compileTask) {
                void prevRunMaxLastModified;
                Intrinsics.checkParameterIsNotNull((Object)compileTask, (String)"compileTask");
                Org_gradle_api_TaskKt.doSetup((Task)((Task)compileTask), (Function1)((Function1)new Function1<AbstractCompile, Unit>(compileTask){
                    final /* synthetic */ AbstractCompile $compileTask;

                    public final void invoke(@NotNull AbstractCompile it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FileCollection fileCollection = this.$compileTask.getClasspath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"compileTask.classpath");
                        Kotlin_collections_Iterable_java_io_FileKt.forClassLoader$default((Iterable)((Iterable)fileCollection), null, (Function1)((Function1)new Function1<URLClassLoader, Unit>(this){
                            final /* synthetic */ setupClassesProcessing.1 this$0;

                            public final void invoke(@NotNull URLClassLoader classLoader) {
                                Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
                                Class[] $receiver$iv = new Class[]{ClassesProcessor.class, ClassesProcessorsGradleTaskFactory.class};
                                int n = $receiver$iv.length;
                                for (int j = 0; j < n; ++j) {
                                    Class element$iv;
                                    Class serviceType = element$iv = $receiver$iv[j];
                                    TaskInputsInternal taskInputsInternal = this.this$0.$compileTask.getInputs();
                                    StringBuilder stringBuilder = new StringBuilder().append("$$");
                                    String string = serviceType.getName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serviceType.name");
                                    String string2 = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null)).append(".names").toString();
                                    Stream stream = Services.readServiceLines((String)serviceType.getName(), (ClassLoader)classLoader);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"Services.readServiceLine\u2026ceType.name, classLoader)");
                                    taskInputsInternal.property(string2, (Object)Java_util_stream_StreamKt.toList((Stream)stream));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                    {
                        this.$compileTask = abstractCompile;
                        super(1);
                    }
                }));
                Timing ioOperationsTiming = new Timing(null, null, 3, null);
                Function1<Function0<? extends R>, R> ioOperation$ = new Function1<Function0<? extends R>, R>(ioOperationsTiming){
                    final /* synthetic */ Timing $ioOperationsTiming;

                    public final <R> R invoke(@NotNull Function0<? extends R> operation) {
                        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
                        long startTime = System.currentTimeMillis();
                        Object result2 = operation.invoke();
                        Java_util_concurrent_atomic_AtomicLongKt.plusAssign((AtomicLong)this.$ioOperationsTiming.getTotalExecutionMillis(), (long)Math.max(0L, System.currentTimeMillis() - startTime));
                        Timing timing = this.$ioOperationsTiming;
                        timing.setExecutionsCount(Java_util_concurrent_atomic_AtomicLongKt.inc((AtomicLong)timing.getExecutionsCount()));
                        timing.getExecutionsCount();
                        return (R)result2;
                    }
                    {
                        this.$ioOperationsTiming = timing;
                        super(1);
                    }
                };
                Ref.LongRef longRef = new Ref.LongRef();
                longRef.element = -1L;
                compileTask.doFirst((Action)new Action<Task>(ioOperation$, compileTask, (Ref.LongRef)prevRunMaxLastModified){
                    final /* synthetic */ setupClassesProcessing.2 $ioOperation$2;
                    final /* synthetic */ AbstractCompile $compileTask;
                    final /* synthetic */ Ref.LongRef $prevRunMaxLastModified;

                    public final void execute(Task it) {
                        this.$ioOperation$2.invoke((Function0)new Function0<Unit>(this){
                            final /* synthetic */ setupClassesProcessing.3 this$0;

                            public final void invoke() {
                                Org_gradle_api_tasks_compile_AbstractCompileKt.forEachCreatedClassFile((AbstractCompile)this.this$0.$compileTask, (Function1)((Function1)new Function1<FileVisitDetails, Unit>(this){
                                    final /* synthetic */ setupClassesProcessing.1 this$0;

                                    public final void invoke(@NotNull FileVisitDetails it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        long lastModified = it.getLastModified();
                                        if (this.this$0.this$0.$prevRunMaxLastModified.element < lastModified) {
                                            this.this$0.this$0.$prevRunMaxLastModified.element = lastModified;
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                }));
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.$ioOperation$2 = var1_1;
                        this.$compileTask = abstractCompile;
                        this.$prevRunMaxLastModified = longRef;
                    }
                });
                Org_gradle_api_TaskKt.doLastOrdered((Task)((Task)compileTask), (Function1)((Function1)new Function1<AbstractCompile, Unit>(this, compileTask, ioOperation$, (Ref.LongRef)prevRunMaxLastModified, ioOperationsTiming){
                    final /* synthetic */ setupClassesProcessing.1 this$0;
                    final /* synthetic */ AbstractCompile $compileTask;
                    final /* synthetic */ setupClassesProcessing.2 $ioOperation$2;
                    final /* synthetic */ Ref.LongRef $prevRunMaxLastModified;
                    final /* synthetic */ Timing $ioOperationsTiming;

                    public final void invoke(@NotNull AbstractCompile $noName_0) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        FileCollection fileCollection = this.$compileTask.getClasspath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"compileTask.classpath");
                        Kotlin_collections_Iterable_java_io_FileKt.forClassLoader$default((Iterable)((Iterable)fileCollection), null, (Function1)((Function1)new Function1<URLClassLoader, Unit>(this){
                            final /* synthetic */ setupClassesProcessing.4 this$0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull URLClassLoader classLoader) {
                                void $receiver$iv$iv;
                                Iterator<T> p1;
                                Object object;
                                Class receiver;
                                Collection<Object> collection;
                                Iterable $receiver$iv$iv2;
                                Iterable $receiver$iv;
                                Object[] objectArray;
                                Object it;
                                Iterable $receiver$iv2;
                                Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
                                Iterable<E> list$iv = new ArrayList<E>();
                                ListBuilder $receiver = (ListBuilder)new ListBuilder<ClassesProcessor>(list$iv){
                                    final /* synthetic */ List $list;
                                    {
                                        this.$list = $captured_local_variable$0;
                                    }

                                    public boolean isEmpty() {
                                        return this.$list.isEmpty();
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean contains(Object element) {
                                        return this.$list.contains(element);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean add(Object element) {
                                        return this.$list.add(element);
                                    }

                                    public void clear() {
                                        this.$list.clear();
                                    }

                                    public boolean containsAll(@NotNull Iterable<? extends ClassesProcessor> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.containsAll((ListBuilder)this, elements);
                                    }

                                    public boolean addAll(@NotNull Iterable<? extends ClassesProcessor> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, elements);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean addAll(Object ... elements) {
                                        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, (Object[])elements);
                                    }

                                    public boolean isNotEmpty() {
                                        return ListBuilder.DefaultImpls.isNotEmpty((ListBuilder)this);
                                    }
                                };
                                Iterable iterable = ServicesKt.loadServices(ClassesProcessor.class, (ClassLoader)classLoader);
                                for (T element$iv : $receiver$iv2) {
                                    it = (ClassesProcessor)element$iv;
                                    $receiver.add(it);
                                }
                                $receiver$iv2 = ServicesKt.loadServices(ClassesProcessorsGradleTaskFactory.class, (ClassLoader)classLoader);
                                for (T element$iv : $receiver$iv2) {
                                    it = (ClassesProcessorsGradleTaskFactory)element$iv;
                                    List list = it.createClassesProcessors(this.this$0.$compileTask);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"it.createClassesProcessors(compileTask)");
                                    $receiver.addAll((Iterable)list);
                                }
                                if ($receiver.isEmpty()) {
                                    return;
                                }
                                List classesProcessors = kotlin.collections.CollectionsKt.sorted((Iterable)list$iv);
                                list$iv = classesProcessors;
                                int n = 0;
                                Object[] objectArray2 = objectArray = new Object[1];
                                Object object2 = "Classes processors: {}";
                                Object object3 = (Task)this.this$0.$compileTask;
                                $receiver = $receiver$iv;
                                Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv2) {
                                    it = item$iv$iv;
                                    collection = destination$iv$iv;
                                    object = JvmClassMappingKt.getJavaClass((Object)receiver);
                                    collection.add(object);
                                }
                                collection = (List)destination$iv$iv;
                                $receiver$iv$iv2 = $receiver$iv = (Iterable)collection;
                                destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv2) {
                                    receiver = (Class)item$iv$iv;
                                    collection = destination$iv$iv;
                                    object = ((Class)((Object)p1)).getName();
                                    collection.add(object);
                                }
                                objectArray[n] = collection = (List)destination$iv$iv;
                                Org_gradle_api_Task_logging_generatedKt.logDebug((Task)object3, (String)object2, (Object[])objectArray2);
                                File destinationDir = this.this$0.$compileTask.getProject().file((Object)this.this$0.$compileTask.getDestinationDir());
                                $receiver$iv2 = (Iterable)RangesKt.until((int)0, (int)(1 + Runtime.getRuntime().availableProcessors() * 2));
                                Iterable iterable2 = $receiver$iv2;
                                Collection destination$iv$iv2 = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                p1 = $receiver$iv$iv.iterator();
                                while (p1.hasNext()) {
                                    int item$iv$iv;
                                    int $i$f$mapTo = item$iv$iv = ((IntIterator)p1).nextInt();
                                    object3 = destination$iv$iv2;
                                    object2 = new Object();
                                    object3.add(object2);
                                }
                                List locks = (List)destination$iv$iv2;
                                Function1<String, Object> getLock$ = new Function1<String, Object>(locks){
                                    final /* synthetic */ List $locks;

                                    @NotNull
                                    public final Object invoke(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        return this.$locks.get(Math.abs(relativePath.hashCode()) % this.$locks.size());
                                    }
                                    {
                                        this.$locks = list;
                                        super(1);
                                    }
                                };
                                Set staleClassRelativePaths = CollectionsKt.concurrentSetOf();
                                LoadingCache loadingCache = CacheBuilder.newBuilder().weigher((Weigher)setupClassesProcessing.bytecodeCache.1.INSTANCE).maximumWeight(0x3200000L).removalListener((RemovalListener)new RemovalListener<String, byte[]>(this, getLock$, staleClassRelativePaths, destinationDir){
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ setupClassesProcessing.3 $getLock$3;
                                    final /* synthetic */ Set $staleClassRelativePaths;
                                    final /* synthetic */ File $destinationDir;

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public final void onRemoval(RemovalNotification<String, byte[]> notification) {
                                        String string = (String)notification.getKey();
                                        if (string == null) {
                                            return;
                                        }
                                        String relativePath = string;
                                        Object object = this.$getLock$3.invoke(relativePath);
                                        synchronized (object) {
                                            RemovalNotification<String, byte[]> removalNotification = notification;
                                            Intrinsics.checkExpressionValueIsNotNull(removalNotification, (String)"notification");
                                            if (RemovalCause.REPLACED == removalNotification.getCause()) {
                                                Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"{}: marking bytecode as modified", (Object[])new Object[]{relativePath});
                                                this.$staleClassRelativePaths.add(relativePath);
                                            } else if (this.$staleClassRelativePaths.contains(relativePath)) {
                                                this.$staleClassRelativePaths.remove(relativePath);
                                                Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"{}: writing modified bytecode to disk", (Object[])new Object[]{relativePath});
                                                this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<Unit>(this, notification, relativePath){
                                                    final /* synthetic */ setupClassesProcessing.bytecodeCache.2 this$0;
                                                    final /* synthetic */ RemovalNotification $notification$inlined;
                                                    final /* synthetic */ String $relativePath$inlined;
                                                    {
                                                        this.this$0 = var1_1;
                                                        this.$notification$inlined = removalNotification;
                                                        this.$relativePath$inlined = string;
                                                        super(0);
                                                    }

                                                    public final void invoke() {
                                                        File file = Java_io_FileKt.createParentDirectories((File)new File(this.this$0.$destinationDir, this.$relativePath$inlined));
                                                        Object object = this.$notification$inlined.getValue();
                                                        if (object == null) {
                                                            Intrinsics.throwNpe();
                                                        }
                                                        FilesKt.writeBytes((File)file, (byte[])((byte[])object));
                                                    }
                                                });
                                            }
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$getLock$3 = var2_2;
                                        this.$staleClassRelativePaths = set;
                                        this.$destinationDir = file;
                                    }
                                }).build((CacheLoader)new CacheLoader<String, byte[]>(this, destinationDir){
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ File $destinationDir;

                                    @NotNull
                                    public byte[] load(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        return (byte[])this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<byte[]>(this, relativePath){
                                            final /* synthetic */ setupClassesProcessing.bytecodeCache.3 this$0;
                                            final /* synthetic */ String $relativePath;

                                            @NotNull
                                            public final byte[] invoke() {
                                                return FilesKt.readBytes((File)new File(this.this$0.$destinationDir, this.$relativePath));
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                this.$relativePath = string;
                                                super(0);
                                            }
                                        });
                                    }
                                    {
                                        this.this$0 = $outer;
                                        this.$destinationDir = $captured_local_variable$1;
                                    }
                                });
                                Intrinsics.checkExpressionValueIsNotNull((Object)loadingCache, (String)"CacheBuilder.newBuilder(\u2026                       })");
                                LoadingCache bytecodeCache2 = loadingCache;
                                Function2<String, byte[], Unit> putBytecodeInCache$ = new Function2<String, byte[], Unit>(this, bytecodeCache2, staleClassRelativePaths){
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ LoadingCache $bytecodeCache;
                                    final /* synthetic */ Set $staleClassRelativePaths;

                                    public final void invoke(@NotNull String relativePath, @NotNull byte[] bytecode) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
                                        if (this.$bytecodeCache.getIfPresent((Object)relativePath) == null) {
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"{}: marking bytecode as modified", (Object[])new Object[]{relativePath});
                                            this.$staleClassRelativePaths.add(relativePath);
                                        }
                                        this.$bytecodeCache.put((Object)relativePath, (Object)bytecode);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$bytecodeCache = loadingCache;
                                        this.$staleClassRelativePaths = set;
                                        super(2);
                                    }
                                };
                                ConcurrentMap excludingFiltersTimings = CollectionsKt.concurrentMapOf();
                                List list$iv2 = new ArrayList<E>();
                                ListBuilder $receiver2 = (ListBuilder)new ListBuilder<ClassesProcessingFilter>(list$iv2){
                                    final /* synthetic */ List $list;
                                    {
                                        this.$list = $captured_local_variable$0;
                                    }

                                    public boolean isEmpty() {
                                        return this.$list.isEmpty();
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean contains(Object element) {
                                        return this.$list.contains(element);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean add(Object element) {
                                        return this.$list.add(element);
                                    }

                                    public void clear() {
                                        this.$list.clear();
                                    }

                                    public boolean containsAll(@NotNull Iterable<? extends ClassesProcessingFilter> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.containsAll((ListBuilder)this, elements);
                                    }

                                    public boolean addAll(@NotNull Iterable<? extends ClassesProcessingFilter> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, elements);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean addAll(Object ... elements) {
                                        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, (Object[])elements);
                                    }

                                    public boolean isNotEmpty() {
                                        return ListBuilder.DefaultImpls.isNotEmpty((ListBuilder)this);
                                    }
                                };
                                $receiver2.addAll((Iterable)ClassesProcessingPlugin.access$getClassesProcessingFilters$cp());
                                Iterable $receiver$iv3 = ClassesProcessingPlugin.access$getClassesProcessingFiltersFactories$cp();
                                TaskContainer taskContainer = $receiver$iv3.iterator();
                                while (taskContainer.hasNext()) {
                                    T element$iv = taskContainer.next();
                                    ClassesProcessingFiltersFactory it2 = (ClassesProcessingFiltersFactory)element$iv;
                                    $receiver2.addAll((Iterable)it2.createClassesProcessingFilters((Task)this.this$0.$compileTask));
                                }
                                List bytecodeFilters = kotlin.collections.CollectionsKt.sorted((Iterable)list$iv2);
                                Function2<String, byte[], Boolean> isExcluded$ = new Function2<String, byte[], Boolean>(this, bytecodeFilters, excludingFiltersTimings){
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ List $bytecodeFilters;
                                    final /* synthetic */ ConcurrentMap $excludingFiltersTimings;

                                    public final boolean invoke(@NotNull String relativePath, @NotNull byte[] bytecode) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
                                        Collection collection = this.$bytecodeFilters;
                                        if (!collection.isEmpty()) {
                                            Object v1;
                                            block3: {
                                                Iterable $receiver$iv = this.$bytecodeFilters;
                                                for (T element$iv : $receiver$iv) {
                                                    ClassesProcessingFilter filter2 = (ClassesProcessingFilter)element$iv;
                                                    long startTime = System.currentTimeMillis();
                                                    boolean result2 = !filter2.canBytecodeBeProcessed(bytecode);
                                                    V v = this.$excludingFiltersTimings.computeIfAbsent(filter2.getClass().getName(), setupClassesProcessing.excludingFilter.1.1.INSTANCE);
                                                    Timing it = (Timing)v;
                                                    Java_util_concurrent_atomic_AtomicLongKt.plusAssign((AtomicLong)it.getTotalExecutionMillis(), (long)Math.max(0L, System.currentTimeMillis() - startTime));
                                                    Timing timing = it;
                                                    timing.setExecutionsCount(Java_util_concurrent_atomic_AtomicLongKt.inc((AtomicLong)timing.getExecutionsCount()));
                                                    timing.getExecutionsCount();
                                                    if (!result2) continue;
                                                    v1 = element$iv;
                                                    break block3;
                                                }
                                                v1 = null;
                                            }
                                            ClassesProcessingFilter excludingFilter2 = v1;
                                            if (excludingFilter2 != null) {
                                                Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"{}: skip processing because of {}", (Object[])new Object[]{relativePath, excludingFilter2.getClass().getName()});
                                                return true;
                                            }
                                        }
                                        return false;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$bytecodeFilters = list;
                                        this.$excludingFiltersTimings = concurrentMap;
                                        super(2);
                                    }
                                };
                                Set processedRelativePaths = CollectionsKt.concurrentSetOf();
                                TaskContainer $receiver3 = taskContainer = this.this$0.this$0.receiver$0;
                                Collection<E> list$iv3 = new ArrayList<E>();
                                Object $receiver4 = (ListBuilder)new ListBuilder<String>(list$iv3){
                                    final /* synthetic */ List $list;
                                    {
                                        this.$list = $captured_local_variable$0;
                                    }

                                    public boolean isEmpty() {
                                        return this.$list.isEmpty();
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean contains(Object element) {
                                        return this.$list.contains(element);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean add(Object element) {
                                        return this.$list.add(element);
                                    }

                                    public void clear() {
                                        this.$list.clear();
                                    }

                                    public boolean containsAll(@NotNull Iterable<? extends String> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.containsAll((ListBuilder)this, elements);
                                    }

                                    public boolean addAll(@NotNull Iterable<? extends String> elements) {
                                        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, elements);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public boolean addAll(Object ... elements) {
                                        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
                                        return ListBuilder.DefaultImpls.addAll((ListBuilder)this, (Object[])elements);
                                    }

                                    public boolean isNotEmpty() {
                                        return ListBuilder.DefaultImpls.isNotEmpty((ListBuilder)this);
                                    }
                                };
                                this.this$0.$ioOperation$2.invoke((Function0)new Function0<Unit>((ListBuilder)$receiver4, this, isExcluded$, bytecodeCache2, classesProcessors, processedRelativePaths){
                                    final /* synthetic */ ListBuilder receiver$0;
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ setupClassesProcessing.5 $isExcluded$5$inlined;
                                    final /* synthetic */ LoadingCache $bytecodeCache$inlined;
                                    final /* synthetic */ List $classesProcessors$inlined;
                                    final /* synthetic */ Set $processedRelativePaths$inlined;
                                    {
                                        this.receiver$0 = listBuilder;
                                        this.this$0 = var2_2;
                                        this.$isExcluded$5$inlined = var3_3;
                                        this.$bytecodeCache$inlined = loadingCache;
                                        this.$classesProcessors$inlined = list;
                                        this.$processedRelativePaths$inlined = set;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        Org_gradle_api_tasks_compile_AbstractCompileKt.forEachCreatedClassFile((AbstractCompile)this.this$0.this$0.$compileTask, (Function1)((Function1)new Function1<FileVisitDetails, Unit>(this){
                                            final /* synthetic */ setupClassesProcessing$1$4$1$$special$$inlined$run$lambda$1 this$0;
                                            {
                                                this.this$0 = var1_1;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull FileVisitDetails it) {
                                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                                String relativePath = it.getRelativePath().toString();
                                                if (it.getLastModified() <= this.this$0.this$0.this$0.$prevRunMaxLastModified.element) {
                                                    Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.this$0.$compileTask), (String)"{}: skip processing because it hasn't been compiled in this build", (Object[])new Object[]{relativePath});
                                                } else {
                                                    setupClassesProcessing.5 v0 = this.this$0.$isExcluded$5$inlined;
                                                    String string = relativePath;
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativePath");
                                                    Object object = this.this$0.$bytecodeCache$inlined.get((Object)relativePath);
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bytecodeCache[relativePath]");
                                                    if (!v0.invoke(string, (byte[])object)) {
                                                        this.this$0.receiver$0.add((Object)relativePath);
                                                    }
                                                }
                                            }
                                        }));
                                    }
                                });
                                List relativePaths2 = list$iv3;
                                list$iv3 = new PriorityBlockingQueue<E>((int)Math.min(Math.round(1.2 * (double)classesProcessors.size() * (double)Math.max(1, relativePaths2.size())), (long)Integer.MAX_VALUE), setupClassesProcessing.processActionsQueue.1.1.INSTANCE);
                                $receiver4 = list$iv3;
                                Iterable $receiver$iv4 = relativePaths2;
                                for (T element$iv : $receiver$iv4) {
                                    String relativePath = (String)element$iv;
                                    processedRelativePaths.add(relativePath);
                                    Iterable $receiver$iv5 = classesProcessors;
                                    for (T element$iv2 : $receiver$iv5) {
                                        ClassesProcessor processor = (ClassesProcessor)element$iv2;
                                        ((PriorityBlockingQueue)$receiver4).add(new ProcessAction(processor, relativePath));
                                    }
                                }
                                BlockingQueue processActionsQueue2 = (BlockingQueue)list$iv3;
                                ProcessContext processContext2 = new ProcessContext(this, destinationDir, getLock$, bytecodeCache2, putBytecodeInCache$, processedRelativePaths, isExcluded$, classesProcessors, processActionsQueue2, classLoader){
                                    private final List<File> _classpath;
                                    private final URLClassLoader _classLoader;
                                    private final LoadingCache<String, BinaryContent> classpathBinaryResourcesCache;
                                    private final Charset textResourceCharset;
                                    final /* synthetic */ setupClassesProcessing.1 this$0;
                                    final /* synthetic */ File $destinationDir;
                                    final /* synthetic */ setupClassesProcessing.3 $getLock$3;
                                    final /* synthetic */ LoadingCache $bytecodeCache;
                                    final /* synthetic */ setupClassesProcessing.4 $putBytecodeInCache$4;
                                    final /* synthetic */ Set $processedRelativePaths;
                                    final /* synthetic */ setupClassesProcessing.5 $isExcluded$5;
                                    final /* synthetic */ List $classesProcessors;
                                    final /* synthetic */ BlockingQueue $processActionsQueue;
                                    final /* synthetic */ URLClassLoader $classLoader;

                                    public File getClassesDir() {
                                        return this.$destinationDir;
                                    }

                                    @NotNull
                                    public List<File> getClasspath() {
                                        return this._classpath;
                                    }

                                    @NotNull
                                    public URLClassLoader getClasspathClassLoader() {
                                        return this._classLoader;
                                    }

                                    public boolean doesResourceExist(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        File file = new File(this.$destinationDir, relativePath);
                                        return file.exists();
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    @Nullable
                                    public byte[] readBinaryResource(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Object object = this.$getLock$3.invoke(relativePath);
                                        synchronized (object) {
                                            File file;
                                            if (StringsKt.endsWith$default((String)relativePath, (String)ClasspathKt.getCLASS_FILE_NAME_SUFFIX(), (boolean)false, (int)2, null)) {
                                                byte[] byArray = (byte[])this.$bytecodeCache.getIfPresent((Object)relativePath);
                                                if (byArray != null) {
                                                    byte[] byArray2 = byArray;
                                                    byte[] it = byArray2;
                                                    return it;
                                                }
                                            }
                                            if (!(file = new File(this.$destinationDir, relativePath)).exists()) {
                                                return null;
                                            }
                                            R r = this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<byte[]>(file){
                                                final /* synthetic */ File $file;

                                                @NotNull
                                                public final byte[] invoke() {
                                                    return FilesKt.readBytes((File)this.$file);
                                                }
                                                {
                                                    this.$file = file;
                                                    super(0);
                                                }
                                            });
                                            byte[] it = (byte[])r;
                                            if (!StringsKt.endsWith$default((String)relativePath, (String)ClasspathKt.getCLASS_FILE_NAME_SUFFIX(), (boolean)false, (int)2, null)) return (byte[])r;
                                            this.$putBytecodeInCache$4.invoke(relativePath, it);
                                            return (byte[])r;
                                        }
                                    }

                                    @Nullable
                                    public String readTextResource(@NotNull String relativePath) {
                                        String string;
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        byte[] byArray = this.readBinaryResource(relativePath);
                                        if (byArray != null) {
                                            byte[] byArray2 = byArray;
                                            Charset charset = this.textResourceCharset;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"textResourceCharset");
                                            Charset charset2 = charset;
                                            string = new String(byArray2, charset2);
                                        } else {
                                            string = null;
                                        }
                                        return string;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void writeBinaryResource(@NotNull String relativePath, @NotNull byte[] content) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                                        Object object = this.$getLock$3.invoke(relativePath);
                                        synchronized (object) {
                                            if (StringsKt.endsWith$default((String)relativePath, (String)ClasspathKt.getCLASS_FILE_NAME_SUFFIX(), (boolean)false, (int)2, null)) {
                                                this.$putBytecodeInCache$4.invoke(relativePath, content);
                                                if (this.$processedRelativePaths.add(relativePath) && !this.$isExcluded$5.invoke(relativePath, content)) {
                                                    Iterable $receiver$iv = this.$classesProcessors;
                                                    for (E element$iv : $receiver$iv) {
                                                        ClassesProcessor processor = (ClassesProcessor)element$iv;
                                                        this.$processActionsQueue.add(new ProcessAction(processor, relativePath));
                                                    }
                                                }
                                            } else {
                                                File file = new File(this.$destinationDir, relativePath);
                                                Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"Writing binary file: {}", (Object[])new Object[]{file});
                                                this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<Unit>(file, this, relativePath, content){
                                                    final /* synthetic */ File $file;
                                                    final /* synthetic */ setupClassesProcessing.processContext.1 this$0;
                                                    final /* synthetic */ String $relativePath$inlined;
                                                    final /* synthetic */ byte[] $content$inlined;
                                                    {
                                                        this.$file = file;
                                                        this.this$0 = var2_2;
                                                        this.$relativePath$inlined = string;
                                                        this.$content$inlined = byArray;
                                                        super(0);
                                                    }

                                                    public final void invoke() {
                                                        FilesKt.writeBytes((File)Java_io_FileKt.createParentDirectories((File)this.$file), (byte[])this.$content$inlined);
                                                    }
                                                });
                                            }
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void writeTextResource(@NotNull String relativePath, @NotNull String text) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                                        Object object = this.$getLock$3.invoke(relativePath);
                                        synchronized (object) {
                                            File file = new File(this.$destinationDir, relativePath);
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"Writing text file: {}", (Object[])new Object[]{file});
                                            this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<Unit>(file, this, relativePath, text){
                                                final /* synthetic */ File $file;
                                                final /* synthetic */ setupClassesProcessing.processContext.1 this$0;
                                                final /* synthetic */ String $relativePath$inlined;
                                                final /* synthetic */ String $text$inlined;
                                                {
                                                    this.$file = file;
                                                    this.this$0 = var2_2;
                                                    this.$relativePath$inlined = string;
                                                    this.$text$inlined = string2;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    File file = Java_io_FileKt.createParentDirectories((File)this.$file);
                                                    Charset charset = this.this$0.getTextResourceCharset();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"textResourceCharset");
                                                    FilesKt.writeText((File)file, (String)this.$text$inlined, (Charset)charset);
                                                }
                                            });
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void appendTextResource(@NotNull String relativePath, @NotNull String text) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                                        Object object = this.$getLock$3.invoke(relativePath);
                                        synchronized (object) {
                                            File file = new File(this.$destinationDir, relativePath);
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"Appending text file: {}", (Object[])new Object[]{file});
                                            this.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<Unit>(file, this, relativePath, text){
                                                final /* synthetic */ File $file;
                                                final /* synthetic */ setupClassesProcessing.processContext.1 this$0;
                                                final /* synthetic */ String $relativePath$inlined;
                                                final /* synthetic */ String $text$inlined;
                                                {
                                                    this.$file = file;
                                                    this.this$0 = var2_2;
                                                    this.$relativePath$inlined = string;
                                                    this.$text$inlined = string2;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    File file;
                                                    File $receiver = file = Java_io_FileKt.createParentDirectories((File)this.$file);
                                                    $receiver.createNewFile();
                                                    Charset charset = this.this$0.getTextResourceCharset();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"textResourceCharset");
                                                    FilesKt.appendText((File)file, (String)this.$text$inlined, (Charset)charset);
                                                }
                                            });
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }

                                    public boolean doesClasspathResourceExist(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        return this.$classLoader.getResource(relativePath) != null;
                                    }

                                    @Nullable
                                    public byte[] readClasspathBinaryResource(@NotNull String relativePath) {
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        return ((BinaryContent)this.classpathBinaryResourcesCache.get((Object)relativePath)).getContent();
                                    }

                                    @Nullable
                                    public String readClasspathTextResource(@NotNull String relativePath) {
                                        String string;
                                        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                        byte[] byArray = this.readClasspathBinaryResource(relativePath);
                                        if (byArray != null) {
                                            byte[] byArray2 = byArray;
                                            Charset charset = this.textResourceCharset;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"textResourceCharset");
                                            Charset charset2 = charset;
                                            string = new String(byArray2, charset2);
                                        } else {
                                            string = null;
                                        }
                                        return string;
                                    }

                                    public final Charset getTextResourceCharset() {
                                        return this.textResourceCharset;
                                    }
                                    {
                                        Collection<URL> collection;
                                        void $receiver$iv$iv;
                                        Collection $receiver$iv;
                                        URLClassLoader uRLClassLoader;
                                        this.this$0 = $outer;
                                        this.$destinationDir = $captured_local_variable$1;
                                        this.$getLock$3 = $captured_local_variable$2;
                                        this.$bytecodeCache = $captured_local_variable$3;
                                        this.$putBytecodeInCache$4 = $captured_local_variable$4;
                                        this.$processedRelativePaths = $captured_local_variable$5;
                                        this.$isExcluded$5 = $captured_local_variable$6;
                                        this.$classesProcessors = $captured_local_variable$7;
                                        this.$processActionsQueue = $captured_local_variable$8;
                                        this.$classLoader = $captured_local_variable$9;
                                        FileCollection fileCollection = this.this$0.this$0.$compileTask.getClasspath();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"compileTask.classpath");
                                        this._classpath = kotlin.collections.CollectionsKt.toList((Iterable)((Iterable)fileCollection));
                                        Iterable iterable = this.getClasspath();
                                        URLClassLoader uRLClassLoader2 = uRLClassLoader;
                                        URLClassLoader uRLClassLoader3 = uRLClassLoader;
                                        setupClassesProcessing.processContext.1 var20_14 = this;
                                        void var12_15 = $receiver$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                        for (T item$iv$iv : $receiver$iv$iv) {
                                            void it;
                                            File file = (File)item$iv$iv;
                                            collection = destination$iv$iv;
                                            URL uRL = it.toURI().toURL();
                                            collection.add(uRL);
                                        }
                                        collection = (List)destination$iv$iv;
                                        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
                                        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                                        if (uRLArray == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                        }
                                        collection = uRLArray;
                                        uRLClassLoader2((URL[])collection);
                                        var20_14._classLoader = uRLClassLoader3;
                                        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumWeight(0x6400000L).weigher((Weigher)setupClassesProcessing.processContext.classpathBinaryResourcesCache.1.INSTANCE).build((CacheLoader)new CacheLoader<String, BinaryContent>(this){
                                            final /* synthetic */ setupClassesProcessing.processContext.1 this$0;

                                            @NotNull
                                            public BinaryContent load(@NotNull String relativePath) {
                                                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                                                return (BinaryContent)this.this$0.this$0.this$0.$ioOperation$2.invoke((Function0)new Function0<BinaryContent>(this, relativePath){
                                                    final /* synthetic */ setupClassesProcessing.processContext.classpathBinaryResourcesCache.2 this$0;
                                                    final /* synthetic */ String $relativePath;

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     * WARNING - void declaration
                                                     */
                                                    @NotNull
                                                    public final BinaryContent invoke() {
                                                        Object object;
                                                        BinaryContent binaryContent;
                                                        BinaryContent binaryContent2;
                                                        block12: {
                                                            block10: {
                                                                Object it;
                                                                void $receiver$iv;
                                                                BinaryContent binaryContent3;
                                                                binaryContent2 = binaryContent3;
                                                                binaryContent = binaryContent3;
                                                                InputStream inputStream = this.this$0.this$0.$classLoader.getResourceAsStream(this.$relativePath);
                                                                if (inputStream == null) break block10;
                                                                AutoCloseable autoCloseable = inputStream;
                                                                BinaryContent binaryContent4 = binaryContent2;
                                                                BinaryContent binaryContent5 = binaryContent;
                                                                boolean closed$iv = false;
                                                                try {
                                                                    it = (InputStream)$receiver$iv;
                                                                    it = ByteStreamsKt.readBytes$default((InputStream)it, (int)0, (int)1, null);
                                                                }
                                                                catch (Exception e$iv) {
                                                                    try {
                                                                        closed$iv = true;
                                                                        try {
                                                                            void v5 = $receiver$iv;
                                                                            if (v5 != null) {
                                                                                v5.close();
                                                                            }
                                                                        }
                                                                        catch (Exception closeException$iv) {
                                                                            e$iv.addSuppressed(closeException$iv);
                                                                        }
                                                                        throw (Throwable)e$iv;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (!closed$iv) {
                                                                            void v6 = $receiver$iv;
                                                                            if (v6 != null) {
                                                                                v6.close();
                                                                            }
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                void v4 = $receiver$iv;
                                                                if (v4 != null) {
                                                                    v4.close();
                                                                }
                                                                Object object2 = it;
                                                                binaryContent = binaryContent5;
                                                                binaryContent2 = binaryContent4;
                                                                object = object2;
                                                                break block12;
                                                            }
                                                            object = null;
                                                        }
                                                        binaryContent2((byte[])object);
                                                        return binaryContent;
                                                    }
                                                    {
                                                        this.this$0 = var1_1;
                                                        this.$relativePath = string;
                                                        super(0);
                                                    }
                                                });
                                            }
                                            {
                                                this.this$0 = $outer;
                                            }
                                        });
                                        Intrinsics.checkExpressionValueIsNotNull((Object)loadingCache, (String)"CacheBuilder.newBuilder(\u2026                       })");
                                        this.classpathBinaryResourcesCache = loadingCache;
                                        this.textResourceCharset = StandardCharsets.UTF_8;
                                    }
                                };
                                ConcurrentMap processorsTimings = CollectionsKt.concurrentMapOf();
                                Object $receiver$iv6 = (AutoCloseable)processContext2;
                                boolean closed$iv = false;
                                try {
                                    setupClassesProcessing.processContext.1 it3 = $receiver$iv6;
                                    while (true) {
                                        Iterator<T> processAction;
                                        if ((ProcessAction)processActionsQueue2.poll() == null) break;
                                        ClassesProcessor classesProcessor = ((ProcessAction)((Object)processAction)).getClassesProcessor();
                                        String relativePath = ((ProcessAction)((Object)processAction)).getRelativePath();
                                        try {
                                            long startTime = System.currentTimeMillis();
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.$compileTask), (String)"{}: executing processor: {}", (Object[])new Object[]{relativePath, classesProcessor.getClass().getName()});
                                            byte[] bytecode = (byte[])bytecodeCache2.get((Object)relativePath);
                                            BytecodeModifier bytecodeModifier = new BytecodeModifier(bytecode, relativePath, this, processActionsQueue2, bytecodeCache2, putBytecodeInCache$, processContext2, processorsTimings){
                                                final /* synthetic */ byte[] $bytecode;
                                                final /* synthetic */ String $relativePath;
                                                final /* synthetic */ setupClassesProcessing.1 this$0;
                                                final /* synthetic */ BlockingQueue $processActionsQueue$inlined;
                                                final /* synthetic */ LoadingCache $bytecodeCache$inlined;
                                                final /* synthetic */ setupClassesProcessing.4 $putBytecodeInCache$4$inlined;
                                                final /* synthetic */ setupClassesProcessing.processContext.1 $processContext$inlined;
                                                final /* synthetic */ ConcurrentMap $processorsTimings$inlined;
                                                {
                                                    this.$bytecode = byArray;
                                                    this.$relativePath = string;
                                                    this.this$0 = var3_3;
                                                    this.$processActionsQueue$inlined = blockingQueue;
                                                    this.$bytecodeCache$inlined = loadingCache;
                                                    this.$putBytecodeInCache$4$inlined = var6_6;
                                                    this.$processContext$inlined = var7_7;
                                                    this.$processorsTimings$inlined = concurrentMap;
                                                }

                                                public final void modify(@NotNull byte[] modifiedBytecode) {
                                                    Intrinsics.checkParameterIsNotNull((Object)modifiedBytecode, (String)"modifiedBytecode");
                                                    if (!Arrays_generatedKt.arrayEquals((byte[])this.$bytecode, (byte[])modifiedBytecode)) {
                                                        Org_objectweb_asm_ClassReaderKt.accept((ClassReader)new ClassReader(this.$bytecode), (ClassVisitor)((ClassVisitor)new CheckClassAdapter((ClassVisitor)new ClassWriter(0))));
                                                        this.$putBytecodeInCache$4$inlined.invoke(this.$relativePath, modifiedBytecode);
                                                    }
                                                }
                                            };
                                            String className = ClasspathKt.resourceNameToClassName((String)relativePath);
                                            classesProcessor.process(bytecode, bytecodeModifier, className, relativePath, processContext2);
                                            V v = processorsTimings.computeIfAbsent(classesProcessor.getClass().getName(), setupClassesProcessing.6.1.INSTANCE);
                                            Timing it4 = (Timing)v;
                                            Java_util_concurrent_atomic_AtomicLongKt.plusAssign((AtomicLong)it4.getTotalExecutionMillis(), (long)Math.max(0L, System.currentTimeMillis() - startTime));
                                            Timing timing = it4;
                                            timing.setExecutionsCount(Java_util_concurrent_atomic_AtomicLongKt.inc((AtomicLong)timing.getExecutionsCount()));
                                            timing.getExecutionsCount();
                                        }
                                        catch (Exception e) {
                                            throw (Throwable)new GradleException("Error processing " + relativePath + " by " + classesProcessor.getClass().getName(), (Throwable)e);
                                        }
                                    }
                                    Unit $i$a$1$run = Unit.INSTANCE;
                                }
                                catch (Exception e$iv) {
                                    try {
                                        closed$iv = true;
                                        try {
                                            $receiver$iv6.close();
                                        }
                                        catch (Exception closeException$iv) {
                                            e$iv.addSuppressed(closeException$iv);
                                        }
                                        throw (Throwable)e$iv;
                                    }
                                    catch (Throwable throwable) {
                                        if (!closed$iv) {
                                            $receiver$iv6.close();
                                        }
                                        throw throwable;
                                    }
                                }
                                $receiver$iv6.close();
                                bytecodeCache2.invalidateAll();
                                bytecodeCache2.cleanUp();
                                if (Org_gradle_api_Task_logging_generatedKt.isDebugLogEnabled((Task)((Task)this.this$0.$compileTask))) {
                                    Timing it5;
                                    Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.$compileTask), (String)"IO operations took {}ms ({}ms per class in average)", (Object[])new Object[]{this.this$0.$ioOperationsTiming.getTotalExecutionMillis(), Math.round(1.0 * (double)this.this$0.$ioOperationsTiming.getTotalExecutionMillis().get() / (double)this.this$0.$ioOperationsTiming.getExecutionsCount().get())});
                                    Object timing = $receiver$iv6 = new Timing(null, null, 3, null);
                                    Iterable $receiver$iv7 = excludingFiltersTimings.values();
                                    for (Object element$iv : $receiver$iv7) {
                                        it5 = (Timing)element$iv;
                                        Java_util_concurrent_atomic_AtomicLongKt.plusAssign((AtomicLong)((Timing)timing).getTotalExecutionMillis(), (AtomicLong)it5.getTotalExecutionMillis());
                                        ((Timing)timing).setExecutionsCount(new AtomicLong(Math.max(((Timing)timing).getExecutionsCount().get(), it5.getExecutionsCount().get())));
                                    }
                                    Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.$compileTask), (String)"Excluding filters took {}ms ({}ms per class in average)", (Object[])new Object[]{((Timing)timing).getTotalExecutionMillis(), Math.round(1.0 * (double)((Timing)timing).getTotalExecutionMillis().get() / (double)((Timing)timing).getExecutionsCount().get())});
                                    excludingFiltersTimings.forEach((BiConsumer)new BiConsumer<String, Timing>(this){
                                        final /* synthetic */ setupClassesProcessing.1 this$0;

                                        public final void accept(String excludingFilterClassName, Timing timing) {
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"Excluding filter {} took {}ms ({}ms per class in average)", (Object[])new Object[]{excludingFilterClassName, timing.getTotalExecutionMillis(), Math.round(1.0 * (double)timing.getTotalExecutionMillis().get() / (double)timing.getExecutionsCount().get())});
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                    timing = $receiver$iv6 = new Timing(null, null, 3, null);
                                    $receiver$iv7 = processorsTimings.values();
                                    for (Object element$iv : $receiver$iv7) {
                                        it5 = (Timing)element$iv;
                                        Java_util_concurrent_atomic_AtomicLongKt.plusAssign((AtomicLong)((Timing)timing).getTotalExecutionMillis(), (AtomicLong)it5.getTotalExecutionMillis());
                                        ((Timing)timing).setExecutionsCount(new AtomicLong(Math.max(((Timing)timing).getExecutionsCount().get(), it5.getExecutionsCount().get())));
                                    }
                                    Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.$compileTask), (String)"Class processors took {}ms ({}ms per class in average)", (Object[])new Object[]{((Timing)timing).getTotalExecutionMillis(), Math.round(1.0 * (double)((Timing)timing).getTotalExecutionMillis().get() / (double)((Timing)timing).getExecutionsCount().get())});
                                    processorsTimings.forEach((BiConsumer)new BiConsumer<String, Timing>(this){
                                        final /* synthetic */ setupClassesProcessing.1 this$0;

                                        public final void accept(String processorClassName, Timing timing) {
                                            Org_gradle_api_Task_logging_generatedKt.logDebug((Task)((Task)this.this$0.this$0.$compileTask), (String)"Class processor {} took {}ms ({}ms per class in average)", (Object[])new Object[]{processorClassName, timing.getTotalExecutionMillis(), Math.round(1.0 * (double)timing.getTotalExecutionMillis().get() / (double)timing.getExecutionsCount().get())});
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                $receiver$iv6 = classesProcessors;
                                Iterator<T> iterator = $receiver$iv6.iterator();
                                while (iterator.hasNext()) {
                                    T element$iv = iterator.next();
                                    ClassesProcessor it6 = (ClassesProcessor)element$iv;
                                    if (!(it6 instanceof Closeable)) continue;
                                    ((Closeable)it6).close();
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$compileTask = abstractCompile;
                        this.$ioOperation$2 = var3_3;
                        this.$prevRunMaxLastModified = longRef;
                        this.$ioOperationsTiming = timing;
                        super(1);
                    }
                }));
            }
            {
                this.receiver$0 = taskContainer;
                super(1);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        classesProcessingFilters = ServicesKt.loadServicesList(ClassesProcessingFilter.class);
        classesProcessingFiltersFactories = ServicesKt.loadServicesList(ClassesProcessingFiltersFactory.class);
    }

    @NotNull
    public static final /* synthetic */ List access$getClassesProcessingFilters$cp() {
        return classesProcessingFilters;
    }

    @NotNull
    public static final /* synthetic */ List access$getClassesProcessingFiltersFactories$cp() {
        return classesProcessingFiltersFactories;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$Timing;", "", "totalExecutionMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "executionsCount", "(Ljava/util/concurrent/atomic/AtomicLong;Ljava/util/concurrent/atomic/AtomicLong;)V", "getExecutionsCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "setExecutionsCount", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "getTotalExecutionMillis", "setTotalExecutionMillis", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-plugins"})
    private static final class Timing {
        @NotNull
        private AtomicLong totalExecutionMillis;
        @NotNull
        private AtomicLong executionsCount;

        @NotNull
        public final AtomicLong getTotalExecutionMillis() {
            return this.totalExecutionMillis;
        }

        public final void setTotalExecutionMillis(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkParameterIsNotNull((Object)atomicLong, (String)"<set-?>");
            this.totalExecutionMillis = atomicLong;
        }

        @NotNull
        public final AtomicLong getExecutionsCount() {
            return this.executionsCount;
        }

        public final void setExecutionsCount(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkParameterIsNotNull((Object)atomicLong, (String)"<set-?>");
            this.executionsCount = atomicLong;
        }

        public Timing(@NotNull AtomicLong totalExecutionMillis, @NotNull AtomicLong executionsCount) {
            Intrinsics.checkParameterIsNotNull((Object)totalExecutionMillis, (String)"totalExecutionMillis");
            Intrinsics.checkParameterIsNotNull((Object)executionsCount, (String)"executionsCount");
            this.totalExecutionMillis = totalExecutionMillis;
            this.executionsCount = executionsCount;
        }

        public /* synthetic */ Timing(AtomicLong atomicLong, AtomicLong atomicLong2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                atomicLong = new AtomicLong(0L);
            }
            if ((n & 2) != 0) {
                atomicLong2 = new AtomicLong(0L);
            }
            this(atomicLong, atomicLong2);
        }

        public Timing() {
            this(null, null, 3, null);
        }

        @NotNull
        public final AtomicLong component1() {
            return this.totalExecutionMillis;
        }

        @NotNull
        public final AtomicLong component2() {
            return this.executionsCount;
        }

        @NotNull
        public final Timing copy(@NotNull AtomicLong totalExecutionMillis, @NotNull AtomicLong executionsCount) {
            Intrinsics.checkParameterIsNotNull((Object)totalExecutionMillis, (String)"totalExecutionMillis");
            Intrinsics.checkParameterIsNotNull((Object)executionsCount, (String)"executionsCount");
            return new Timing(totalExecutionMillis, executionsCount);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Timing copy$default(Timing timing, AtomicLong atomicLong, AtomicLong atomicLong2, int n, Object object) {
            if ((n & 1) != 0) {
                atomicLong = timing.totalExecutionMillis;
            }
            if ((n & 2) != 0) {
                atomicLong2 = timing.executionsCount;
            }
            return timing.copy(atomicLong, atomicLong2);
        }

        public String toString() {
            return "Timing(totalExecutionMillis=" + this.totalExecutionMillis + ", executionsCount=" + this.executionsCount + ")";
        }

        public int hashCode() {
            AtomicLong atomicLong = this.totalExecutionMillis;
            AtomicLong atomicLong2 = this.executionsCount;
            return (atomicLong != null ? atomicLong.hashCode() : 0) * 31 + (atomicLong2 != null ? atomicLong2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Timing)) break block3;
                    Timing timing = (Timing)object;
                    if (!Intrinsics.areEqual((Object)this.totalExecutionMillis, (Object)timing.totalExecutionMillis) || !Intrinsics.areEqual((Object)this.executionsCount, (Object)timing.executionsCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$BinaryContent;", "", "content", "", "([B)V", "getContent", "()[B", "gradle-plugins"})
    private static final class BinaryContent {
        @Nullable
        private final byte[] content;

        @Nullable
        public final byte[] getContent() {
            return this.content;
        }

        public BinaryContent(@Nullable byte[] content) {
            this.content = content;
        }

        @SuppressFBWarnings
        protected /* synthetic */ BinaryContent() {
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$ProcessAction;", "", "classesProcessor", "Lname/remal/gradle_plugins/api/classes_processing/ClassesProcessor;", "relativePath", "", "(Lname/remal/gradle_plugins/api/classes_processing/ClassesProcessor;Ljava/lang/String;)V", "getClassesProcessor", "()Lname/remal/gradle_plugins/api/classes_processing/ClassesProcessor;", "getRelativePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-plugins"})
    private static final class ProcessAction {
        @NotNull
        private final ClassesProcessor classesProcessor;
        @NotNull
        private final String relativePath;

        @NotNull
        public final ClassesProcessor getClassesProcessor() {
            return this.classesProcessor;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        public ProcessAction(@NotNull ClassesProcessor classesProcessor, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)classesProcessor, (String)"classesProcessor");
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            this.classesProcessor = classesProcessor;
            this.relativePath = relativePath;
        }

        @NotNull
        public final ClassesProcessor component1() {
            return this.classesProcessor;
        }

        @NotNull
        public final String component2() {
            return this.relativePath;
        }

        @NotNull
        public final ProcessAction copy(@NotNull ClassesProcessor classesProcessor, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)classesProcessor, (String)"classesProcessor");
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new ProcessAction(classesProcessor, relativePath);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ProcessAction copy$default(ProcessAction processAction, ClassesProcessor classesProcessor, String string, int n, Object object) {
            if ((n & 1) != 0) {
                classesProcessor = processAction.classesProcessor;
            }
            if ((n & 2) != 0) {
                string = processAction.relativePath;
            }
            return processAction.copy(classesProcessor, string);
        }

        public String toString() {
            return "ProcessAction(classesProcessor=" + this.classesProcessor + ", relativePath=" + this.relativePath + ")";
        }

        public int hashCode() {
            ClassesProcessor classesProcessor = this.classesProcessor;
            String string = this.relativePath;
            return (classesProcessor != null ? classesProcessor.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ProcessAction)) break block3;
                    ProcessAction processAction = (ProcessAction)object;
                    if (!Intrinsics.areEqual((Object)this.classesProcessor, (Object)processAction.classesProcessor) || !Intrinsics.areEqual((Object)this.relativePath, (Object)processAction.relativePath)) break block3;
                }
                return true;
            }
            return false;
        }

        @SuppressFBWarnings
        protected /* synthetic */ ProcessAction() {
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$Companion;", "", "()V", "classesProcessingFilters", "", "Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingFilter;", "classesProcessingFiltersFactories", "Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingFiltersFactory;", "gradle-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

