/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanoweb;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.syntax.SyntaxException;
import org.nanocontainer.nanoweb.ScriptException;

public class CachingScriptClassLoader {
    private final Map scriptLoadTimestamps = Collections.synchronizedMap(new HashMap());
    private final Map scriptClasses = Collections.synchronizedMap(new HashMap());
    private static final Long NEVER = new Long(Long.MIN_VALUE);

    public Class getClass(URL scriptURL) throws IOException, ScriptException {
        String urlAsString = scriptURL.toExternalForm();
        URLConnection urlConnection = scriptURL.openConnection();
        Long lastLoaded = (Long)this.scriptLoadTimestamps.get(urlAsString);
        if (lastLoaded == null) {
            lastLoaded = NEVER;
        }
        Class scriptClass = lastLoaded < urlConnection.getLastModified() ? this.loadAndCache(scriptURL, urlConnection) : (Class)this.scriptClasses.get(urlAsString);
        return scriptClass;
    }

    private Class loadAndCache(URL scriptURL, URLConnection urlConnection) throws IOException, ScriptException {
        Class scriptClass = this.loadGroovyClass(urlConnection, scriptURL);
        String urlAsString = scriptURL.toExternalForm();
        this.scriptClasses.put(urlAsString, scriptClass);
        long lastChanged = urlConnection.getLastModified();
        this.scriptLoadTimestamps.put(urlAsString, new Long(lastChanged));
        return scriptClass;
    }

    private Class loadGroovyClass(URLConnection urlConnection, URL scriptURL) throws IOException, ScriptException {
        GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
        try {
            Class scriptClass = loader.parseClass(urlConnection.getInputStream(), scriptURL.getFile());
            return scriptClass;
        }
        catch (SyntaxException e) {
            throw new ScriptException(scriptURL, (Exception)((Object)e));
        }
    }
}

