/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanoweb;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ognl.Ognl;
import ognl.OgnlException;
import org.nanocontainer.nanoweb.CachingScriptClassLoader;
import org.nanocontainer.nanoweb.ChainingDispatcher;
import org.nanocontainer.nanoweb.Dispatcher;
import org.nanocontainer.nanoweb.ScriptException;
import org.nanocontainer.servlet.KeyConstants;
import org.nanocontainer.servlet.RequestScopeObjectReference;
import org.nanocontainer.servlet.ServletRequestContainerLauncher;
import org.picocontainer.MutablePicoContainer;

public class NanoWebServlet
extends HttpServlet
implements KeyConstants {
    private final Dispatcher dispatcher = new ChainingDispatcher();
    private final CachingScriptClassLoader cachingScriptClassLoader = new CachingScriptClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletRequestContainerLauncher containerLauncher = new ServletRequestContainerLauncher(this.getServletContext(), httpServletRequest);
        try {
            containerLauncher.startContainer();
            String servletPath = NanoWebServlet.getServletPath(httpServletRequest);
            String scriptPathWithoutExtension = servletPath.substring(0, servletPath.lastIndexOf(47));
            Object action = this.getActionObject(scriptPathWithoutExtension, httpServletRequest);
            this.setPropertiesWithOgnl(httpServletRequest, action);
            int dot = servletPath.lastIndexOf(46);
            String actionMethod = servletPath.substring(servletPath.lastIndexOf(47) + 1, dot);
            String result = this.execute(action, actionMethod);
            httpServletRequest.setAttribute("action", action);
            ServletContext servletContext = this.getServletContext();
            this.dispatcher.dispatch(servletContext, httpServletRequest, httpServletResponse, scriptPathWithoutExtension, actionMethod, result);
        }
        catch (ScriptException e) {
            int c;
            e.printStackTrace();
            PrintWriter writer = httpServletResponse.getWriter();
            writer.println("<html>");
            writer.println("<pre>");
            e.printStackTrace(writer);
            writer.println(httpServletRequest.getRequestURI());
            URL scriptURL = e.getScriptURL();
            InputStream in = scriptURL.openStream();
            while ((c = in.read()) != -1) {
                writer.write(c);
            }
            writer.println("</pre>");
            writer.println("</html>");
        }
        finally {
            try {
                containerLauncher.killContainer();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Object getActionObject(String path, HttpServletRequest request) throws ServletException, ScriptException {
        MutablePicoContainer requestContainer = this.getRequestContainer((ServletRequest)request);
        Object action = requestContainer.getComponentInstance((Object)path);
        if (action == null) {
            try {
                action = this.getScriptAction(path + ".groovy", requestContainer);
            }
            catch (IOException e) {
                this.log("Failed to load action class", e);
                throw new ServletException((Throwable)e);
            }
        }
        if (action == null) {
            String msg = "No action found for '" + path + "'";
            throw new ServletException(msg);
        }
        return action;
    }

    private Object getScriptAction(String scriptPath, MutablePicoContainer requestContainer) throws IOException, ScriptException {
        URL scriptURL = this.getServletContext().getResource(scriptPath);
        Object result = null;
        if (scriptURL != null) {
            Class scriptClass = this.cachingScriptClassLoader.getClass(scriptURL);
            requestContainer.registerComponentImplementation((Object)scriptPath, scriptClass);
            result = requestContainer.getComponentInstance((Object)scriptPath);
        }
        return result;
    }

    private void setPropertiesWithOgnl(HttpServletRequest servletRequest, Object action) throws ServletException {
        Enumeration parameterNames = servletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletRequest.getParameter(parameterName);
            try {
                Ognl.setValue((String)parameterName, (Object)action, (Object)parameterValue);
            }
            catch (OgnlException e) {
                this.log("Failed to set property with OGNL", e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String execute(Object actionObject, String actionMethodName) throws ServletException {
        Method actionMethod = null;
        try {
            actionMethod = actionObject.getClass().getMethod(actionMethodName, null);
        }
        catch (NoSuchMethodException e) {
            String message = "The " + actionObject.getClass().getName() + " doesn't have the method " + actionMethodName + "()";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        try {
            String view = (String)actionMethod.invoke(actionObject, null);
            return view;
        }
        catch (IllegalAccessException e) {
            String message = actionObject.getClass().getName() + "." + actionMethodName + "() isn't public";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String message = "Failed to actionMethod " + actionObject.getClass().getName() + "." + actionMethodName + "()";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    static String getServletPath(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return servletPath;
    }

    private MutablePicoContainer getRequestContainer(ServletRequest request) {
        RequestScopeObjectReference ref = new RequestScopeObjectReference(request, "nanocontainer.request");
        return (MutablePicoContainer)ref.get();
    }
}

