/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.inventory.operations.admin_inventories;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.inventory.models.ApimodelsListInventoryResp;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminListInventories
extends Operation {
    private String path = "/inventory/v1/admin/namespaces/{namespace}/inventories";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String inventoryConfigurationCode;
    private Integer limit;
    private Integer offset;
    private String sortBy;
    private String userId;

    @Deprecated
    public AdminListInventories(String customBasePath, String namespace, String inventoryConfigurationCode, Integer limit, Integer offset, String sortBy, String userId) {
        this.namespace = namespace;
        this.inventoryConfigurationCode = inventoryConfigurationCode;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.userId = userId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("inventoryConfigurationCode", this.inventoryConfigurationCode == null ? null : Arrays.asList(this.inventoryConfigurationCode));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ApimodelsListInventoryResp parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsListInventoryResp().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("inventoryConfigurationCode", "None");
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        result.put("userId", "None");
        return result;
    }

    public static AdminListInventoriesBuilder builder() {
        return new AdminListInventoriesBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInventoryConfigurationCode() {
        return this.inventoryConfigurationCode;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setInventoryConfigurationCode(String inventoryConfigurationCode) {
        this.inventoryConfigurationCode = inventoryConfigurationCode;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class AdminListInventoriesBuilder {
        private String customBasePath;
        private String namespace;
        private String inventoryConfigurationCode;
        private Integer limit;
        private Integer offset;
        private String userId;
        private String sortBy;

        public AdminListInventoriesBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public AdminListInventoriesBuilder sortByFromEnum(SortBy sortBy) {
            this.sortBy = sortBy.toString();
            return this;
        }

        AdminListInventoriesBuilder() {
        }

        public AdminListInventoriesBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminListInventoriesBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminListInventoriesBuilder inventoryConfigurationCode(String inventoryConfigurationCode) {
            this.inventoryConfigurationCode = inventoryConfigurationCode;
            return this;
        }

        public AdminListInventoriesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminListInventoriesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminListInventoriesBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminListInventories build() {
            return new AdminListInventories(this.customBasePath, this.namespace, this.inventoryConfigurationCode, this.limit, this.offset, this.sortBy, this.userId);
        }

        public String toString() {
            return "AdminListInventories.AdminListInventoriesBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", inventoryConfigurationCode=" + this.inventoryConfigurationCode + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", userId=" + this.userId + ")";
        }
    }

    public static enum SortBy {
        CreatedAt("createdAt"),
        CreatedAtasc("createdAt:asc"),
        CreatedAtdesc("createdAt:desc"),
        InventoryConfigurationCode("inventoryConfigurationCode"),
        InventoryConfigurationCodeasc("inventoryConfigurationCode:asc"),
        InventoryConfigurationCodedesc("inventoryConfigurationCode:desc"),
        UpdatedAt("updatedAt"),
        UpdatedAtasc("updatedAt:asc"),
        UpdatedAtdesc("updatedAt:desc");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

