/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.inventory.operations.admin_items;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.inventory.models.ApimodelsItemResp;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetInventoryItem
extends Operation {
    private String path = "/inventory/v1/admin/namespaces/{namespace}/inventories/{inventoryId}/slots/{slotId}/sourceItems/{sourceItemId}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String inventoryId;
    private String namespace;
    private String slotId;
    private String sourceItemId;

    @Deprecated
    public AdminGetInventoryItem(String customBasePath, String inventoryId, String namespace, String slotId, String sourceItemId) {
        this.inventoryId = inventoryId;
        this.namespace = namespace;
        this.slotId = slotId;
        this.sourceItemId = sourceItemId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.inventoryId != null) {
            pathParams.put("inventoryId", this.inventoryId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.slotId != null) {
            pathParams.put("slotId", this.slotId);
        }
        if (this.sourceItemId != null) {
            pathParams.put("sourceItemId", this.sourceItemId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.inventoryId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        if (this.slotId == null) {
            return false;
        }
        return this.sourceItemId != null;
    }

    public ApimodelsItemResp parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsItemResp().createFromJson(json);
    }

    public static AdminGetInventoryItemBuilder builder() {
        return new AdminGetInventoryItemBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public String getSourceItemId() {
        return this.sourceItemId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryId = inventoryId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public void setSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
    }

    public static class AdminGetInventoryItemBuilder {
        private String customBasePath;
        private String inventoryId;
        private String namespace;
        private String slotId;
        private String sourceItemId;

        AdminGetInventoryItemBuilder() {
        }

        public AdminGetInventoryItemBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetInventoryItemBuilder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public AdminGetInventoryItemBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetInventoryItemBuilder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public AdminGetInventoryItemBuilder sourceItemId(String sourceItemId) {
            this.sourceItemId = sourceItemId;
            return this;
        }

        public AdminGetInventoryItem build() {
            return new AdminGetInventoryItem(this.customBasePath, this.inventoryId, this.namespace, this.slotId, this.sourceItemId);
        }

        public String toString() {
            return "AdminGetInventoryItem.AdminGetInventoryItemBuilder(customBasePath=" + this.customBasePath + ", inventoryId=" + this.inventoryId + ", namespace=" + this.namespace + ", slotId=" + this.slotId + ", sourceItemId=" + this.sourceItemId + ")";
        }
    }
}

