/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogconfigConfiguration
extends Model {
    @JsonProperty(value="logLevel")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String logLevel;
    @JsonProperty(value="logLevelDB")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String logLevelDB;
    @JsonProperty(value="slowQueryThreshold")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long slowQueryThreshold;
    @JsonProperty(value="socketLogEnabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean socketLogEnabled;

    @JsonIgnore
    public String getLogLevel() {
        return this.logLevel;
    }

    @JsonIgnore
    public LogLevel getLogLevelAsEnum() {
        return LogLevel.valueOf(this.logLevel);
    }

    @JsonIgnore
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @JsonIgnore
    public void setLogLevelFromEnum(LogLevel logLevel) {
        this.logLevel = logLevel.toString();
    }

    @JsonIgnore
    public String getLogLevelDB() {
        return this.logLevelDB;
    }

    @JsonIgnore
    public LogLevelDB getLogLevelDBAsEnum() {
        return LogLevelDB.valueOf(this.logLevelDB);
    }

    @JsonIgnore
    public void setLogLevelDB(String logLevelDB) {
        this.logLevelDB = logLevelDB;
    }

    @JsonIgnore
    public void setLogLevelDBFromEnum(LogLevelDB logLevelDB) {
        this.logLevelDB = logLevelDB.toString();
    }

    @JsonIgnore
    public LogconfigConfiguration createFromJson(String json) throws JsonProcessingException {
        return (LogconfigConfiguration)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<LogconfigConfiguration> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<LogconfigConfiguration>>(){});
    }

    public static LogconfigConfigurationBuilder builder() {
        return new LogconfigConfigurationBuilder();
    }

    public Long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public Boolean getSocketLogEnabled() {
        return this.socketLogEnabled;
    }

    @JsonProperty(value="slowQueryThreshold")
    public void setSlowQueryThreshold(Long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    @JsonProperty(value="socketLogEnabled")
    public void setSocketLogEnabled(Boolean socketLogEnabled) {
        this.socketLogEnabled = socketLogEnabled;
    }

    @Deprecated
    public LogconfigConfiguration(String logLevel, String logLevelDB, Long slowQueryThreshold, Boolean socketLogEnabled) {
        this.logLevel = logLevel;
        this.logLevelDB = logLevelDB;
        this.slowQueryThreshold = slowQueryThreshold;
        this.socketLogEnabled = socketLogEnabled;
    }

    public LogconfigConfiguration() {
    }

    public static class LogconfigConfigurationBuilder {
        private Long slowQueryThreshold;
        private Boolean socketLogEnabled;
        private String logLevel;
        private String logLevelDB;

        public LogconfigConfigurationBuilder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public LogconfigConfigurationBuilder logLevelFromEnum(LogLevel logLevel) {
            this.logLevel = logLevel.toString();
            return this;
        }

        public LogconfigConfigurationBuilder logLevelDB(String logLevelDB) {
            this.logLevelDB = logLevelDB;
            return this;
        }

        public LogconfigConfigurationBuilder logLevelDBFromEnum(LogLevelDB logLevelDB) {
            this.logLevelDB = logLevelDB.toString();
            return this;
        }

        LogconfigConfigurationBuilder() {
        }

        @JsonProperty(value="slowQueryThreshold")
        public LogconfigConfigurationBuilder slowQueryThreshold(Long slowQueryThreshold) {
            this.slowQueryThreshold = slowQueryThreshold;
            return this;
        }

        @JsonProperty(value="socketLogEnabled")
        public LogconfigConfigurationBuilder socketLogEnabled(Boolean socketLogEnabled) {
            this.socketLogEnabled = socketLogEnabled;
            return this;
        }

        public LogconfigConfiguration build() {
            return new LogconfigConfiguration(this.logLevel, this.logLevelDB, this.slowQueryThreshold, this.socketLogEnabled);
        }

        public String toString() {
            return "LogconfigConfiguration.LogconfigConfigurationBuilder(logLevel=" + this.logLevel + ", logLevelDB=" + this.logLevelDB + ", slowQueryThreshold=" + this.slowQueryThreshold + ", socketLogEnabled=" + this.socketLogEnabled + ")";
        }
    }

    public static enum LogLevelDB {
        Debug("debug"),
        Error("error"),
        Fatal("fatal"),
        Info("info"),
        Panic("panic"),
        Trace("trace"),
        Warning("warning");

        private String value;

        private LogLevelDB(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum LogLevel {
        Debug("debug"),
        Error("error"),
        Fatal("fatal"),
        Info("info"),
        Panic("panic"),
        Trace("trace"),
        Warning("warning");

        private String value;

        private LogLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

