/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.wrappers;

import java.util.List;
import net.accelbyte.sdk.api.lobby.models.LogAppMessageDeclaration;
import net.accelbyte.sdk.api.lobby.models.ModelsPartyData;
import net.accelbyte.sdk.api.lobby.operations.lobby_operations.AdminJoinPartyV1;
import net.accelbyte.sdk.api.lobby.operations.lobby_operations.AdminUpdatePartyAttributesV1;
import net.accelbyte.sdk.api.lobby.operations.lobby_operations.PublicGetMessages;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class LobbyOperations {
    private RequestRunner sdk;
    private String customBasePath = "";

    public LobbyOperations(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("lobby");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public LobbyOperations(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ModelsPartyData adminUpdatePartyAttributesV1(AdminUpdatePartyAttributesV1 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void adminJoinPartyV1(AdminJoinPartyV1 input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<LogAppMessageDeclaration> publicGetMessages(PublicGetMessages input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

