/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class ListOfFriendsResponse {
    private Integer code;
    private List<String> friendIds;
    private String id;

    private ListOfFriendsResponse() {
    }

    @Deprecated
    public ListOfFriendsResponse(Integer code, List<String> friendIds, String id) {
        this.code = code;
        this.friendIds = friendIds;
        this.id = id;
    }

    public static String getType() {
        return "listOfFriendsResponse";
    }

    public static ListOfFriendsResponse createFromWSM(String message) {
        ListOfFriendsResponse result = new ListOfFriendsResponse();
        Map response = Helper.parseWSM((String)message);
        result.code = response.get("code") != null ? Integer.valueOf((String)response.get("code")) : null;
        result.friendIds = response.get("friendIds") != null ? Helper.convertWSMListToListString((String)((String)response.get("friendIds"))) : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(ListOfFriendsResponse.getType());
        if (this.code != null) {
            stringBuilder.append("\n").append("code: ").append(this.code);
        }
        if (this.friendIds != null) {
            stringBuilder.append("\n").append("friendIds: ").append(Helper.listToWSMList(this.friendIds));
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "code");
        result.put("friendIds", "friendIds");
        result.put("id", "id");
        return result;
    }

    public static ListOfFriendsResponseBuilder builder() {
        return new ListOfFriendsResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public List<String> getFriendIds() {
        return this.friendIds;
    }

    public String getId() {
        return this.id;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setFriendIds(List<String> friendIds) {
        this.friendIds = friendIds;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class ListOfFriendsResponseBuilder {
        private Integer code;
        private List<String> friendIds;
        private String id;

        ListOfFriendsResponseBuilder() {
        }

        public ListOfFriendsResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public ListOfFriendsResponseBuilder friendIds(List<String> friendIds) {
            this.friendIds = friendIds;
            return this;
        }

        public ListOfFriendsResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ListOfFriendsResponse build() {
            return new ListOfFriendsResponse(this.code, this.friendIds, this.id);
        }

        public String toString() {
            return "ListOfFriendsResponse.ListOfFriendsResponseBuilder(code=" + this.code + ", friendIds=" + this.friendIds + ", id=" + this.id + ")";
        }
    }
}

