/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class PartyInfoResponse {
    private Integer code;
    private Map<String, ?> customAttributes;
    private String id;
    private String invitationToken;
    private String invitees;
    private String leaderId;
    private String members;
    private String partyId;

    private PartyInfoResponse() {
    }

    @Deprecated
    public PartyInfoResponse(Integer code, Map<String, ?> customAttributes, String id, String invitationToken, String invitees, String leaderId, String members, String partyId) {
        this.code = code;
        this.customAttributes = customAttributes;
        this.id = id;
        this.invitationToken = invitationToken;
        this.invitees = invitees;
        this.leaderId = leaderId;
        this.members = members;
        this.partyId = partyId;
    }

    public static String getType() {
        return "partyInfoResponse";
    }

    public static PartyInfoResponse createFromWSM(String message) {
        PartyInfoResponse result = new PartyInfoResponse();
        Map response = Helper.parseWSM((String)message);
        result.code = response.get("code") != null ? Integer.valueOf((String)response.get("code")) : null;
        result.customAttributes = response.get("customAttributes") != null ? Helper.convertJsonToMap((String)((String)response.get("customAttributes"))) : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.invitationToken = response.get("invitationToken") != null ? (String)response.get("invitationToken") : null;
        result.invitees = response.get("invitees") != null ? (String)response.get("invitees") : null;
        result.leaderId = response.get("leaderId") != null ? (String)response.get("leaderId") : null;
        result.members = response.get("members") != null ? (String)response.get("members") : null;
        result.partyId = response.get("partyId") != null ? (String)response.get("partyId") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(PartyInfoResponse.getType());
        if (this.code != null) {
            stringBuilder.append("\n").append("code: ").append(this.code);
        }
        if (this.customAttributes != null) {
            try {
                String json = new ObjectMapper().writeValueAsString(this.customAttributes);
                stringBuilder.append("\n").append("customAttributes: ").append(json);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.invitationToken != null) {
            stringBuilder.append("\n").append("invitationToken: ").append(this.invitationToken);
        }
        if (this.invitees != null) {
            stringBuilder.append("\n").append("invitees: ").append(this.invitees);
        }
        if (this.leaderId != null) {
            stringBuilder.append("\n").append("leaderId: ").append(this.leaderId);
        }
        if (this.members != null) {
            stringBuilder.append("\n").append("members: ").append(this.members);
        }
        if (this.partyId != null) {
            stringBuilder.append("\n").append("partyId: ").append(this.partyId);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("code", "code");
        result.put("customAttributes", "customAttributes");
        result.put("id", "id");
        result.put("invitationToken", "invitationToken");
        result.put("invitees", "invitees");
        result.put("leaderId", "leaderId");
        result.put("members", "members");
        result.put("partyId", "partyId");
        return result;
    }

    public static PartyInfoResponseBuilder builder() {
        return new PartyInfoResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public Map<String, ?> getCustomAttributes() {
        return this.customAttributes;
    }

    public String getId() {
        return this.id;
    }

    public String getInvitationToken() {
        return this.invitationToken;
    }

    public String getInvitees() {
        return this.invitees;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public String getMembers() {
        return this.members;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setCustomAttributes(Map<String, ?> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInvitationToken(String invitationToken) {
        this.invitationToken = invitationToken;
    }

    public void setInvitees(String invitees) {
        this.invitees = invitees;
    }

    public void setLeaderId(String leaderId) {
        this.leaderId = leaderId;
    }

    public void setMembers(String members) {
        this.members = members;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public static class PartyInfoResponseBuilder {
        private Integer code;
        private Map<String, ?> customAttributes;
        private String id;
        private String invitationToken;
        private String invitees;
        private String leaderId;
        private String members;
        private String partyId;

        PartyInfoResponseBuilder() {
        }

        public PartyInfoResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public PartyInfoResponseBuilder customAttributes(Map<String, ?> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public PartyInfoResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PartyInfoResponseBuilder invitationToken(String invitationToken) {
            this.invitationToken = invitationToken;
            return this;
        }

        public PartyInfoResponseBuilder invitees(String invitees) {
            this.invitees = invitees;
            return this;
        }

        public PartyInfoResponseBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        public PartyInfoResponseBuilder members(String members) {
            this.members = members;
            return this;
        }

        public PartyInfoResponseBuilder partyId(String partyId) {
            this.partyId = partyId;
            return this;
        }

        public PartyInfoResponse build() {
            return new PartyInfoResponse(this.code, this.customAttributes, this.id, this.invitationToken, this.invitees, this.leaderId, this.members, this.partyId);
        }

        public String toString() {
            return "PartyInfoResponse.PartyInfoResponseBuilder(code=" + this.code + ", customAttributes=" + this.customAttributes + ", id=" + this.id + ", invitationToken=" + this.invitationToken + ", invitees=" + this.invitees + ", leaderId=" + this.leaderId + ", members=" + this.members + ", partyId=" + this.partyId + ")";
        }
    }
}

