/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class StartMatchmakingRequest {
    private String extraAttributes;
    private String gameMode;
    private String id;
    private Map<String, ?> partyAttributes;
    private Integer priority;
    private String tempParty;

    private StartMatchmakingRequest() {
    }

    @Deprecated
    public StartMatchmakingRequest(String extraAttributes, String gameMode, String id, Map<String, ?> partyAttributes, Integer priority, String tempParty) {
        this.extraAttributes = extraAttributes;
        this.gameMode = gameMode;
        this.id = id;
        this.partyAttributes = partyAttributes;
        this.priority = priority;
        this.tempParty = tempParty;
    }

    public static String getType() {
        return "startMatchmakingRequest";
    }

    public static StartMatchmakingRequest createFromWSM(String message) {
        StartMatchmakingRequest result = new StartMatchmakingRequest();
        Map response = Helper.parseWSM((String)message);
        result.extraAttributes = response.get("extraAttributes") != null ? (String)response.get("extraAttributes") : null;
        result.gameMode = response.get("gameMode") != null ? (String)response.get("gameMode") : null;
        result.id = response.get("id") != null ? (String)response.get("id") : null;
        result.partyAttributes = response.get("partyAttributes") != null ? Helper.convertJsonToMap((String)((String)response.get("partyAttributes"))) : null;
        result.priority = response.get("priority") != null ? Integer.valueOf((String)response.get("priority")) : null;
        result.tempParty = response.get("tempParty") != null ? (String)response.get("tempParty") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(StartMatchmakingRequest.getType());
        if (this.extraAttributes != null) {
            stringBuilder.append("\n").append("extraAttributes: ").append(this.extraAttributes);
        }
        if (this.gameMode != null) {
            stringBuilder.append("\n").append("gameMode: ").append(this.gameMode);
        }
        if (this.id != null) {
            stringBuilder.append("\n").append("id: ").append(this.id);
        } else {
            stringBuilder.append("\n").append("id: ").append(Helper.generateUUID());
        }
        if (this.partyAttributes != null) {
            try {
                String json = new ObjectMapper().writeValueAsString(this.partyAttributes);
                stringBuilder.append("\n").append("partyAttributes: ").append(json);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        if (this.priority != null) {
            stringBuilder.append("\n").append("priority: ").append(this.priority);
        }
        if (this.tempParty != null) {
            stringBuilder.append("\n").append("tempParty: ").append(this.tempParty);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("extraAttributes", "extraAttributes");
        result.put("gameMode", "gameMode");
        result.put("id", "id");
        result.put("partyAttributes", "partyAttributes");
        result.put("priority", "priority");
        result.put("tempParty", "tempParty");
        return result;
    }

    public static StartMatchmakingRequestBuilder builder() {
        return new StartMatchmakingRequestBuilder();
    }

    public String getExtraAttributes() {
        return this.extraAttributes;
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ?> getPartyAttributes() {
        return this.partyAttributes;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getTempParty() {
        return this.tempParty;
    }

    public void setExtraAttributes(String extraAttributes) {
        this.extraAttributes = extraAttributes;
    }

    public void setGameMode(String gameMode) {
        this.gameMode = gameMode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPartyAttributes(Map<String, ?> partyAttributes) {
        this.partyAttributes = partyAttributes;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setTempParty(String tempParty) {
        this.tempParty = tempParty;
    }

    public static class StartMatchmakingRequestBuilder {
        private String extraAttributes;
        private String gameMode;
        private String id;
        private Map<String, ?> partyAttributes;
        private Integer priority;
        private String tempParty;

        StartMatchmakingRequestBuilder() {
        }

        public StartMatchmakingRequestBuilder extraAttributes(String extraAttributes) {
            this.extraAttributes = extraAttributes;
            return this;
        }

        public StartMatchmakingRequestBuilder gameMode(String gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public StartMatchmakingRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public StartMatchmakingRequestBuilder partyAttributes(Map<String, ?> partyAttributes) {
            this.partyAttributes = partyAttributes;
            return this;
        }

        public StartMatchmakingRequestBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public StartMatchmakingRequestBuilder tempParty(String tempParty) {
            this.tempParty = tempParty;
            return this;
        }

        public StartMatchmakingRequest build() {
            return new StartMatchmakingRequest(this.extraAttributes, this.gameMode, this.id, this.partyAttributes, this.priority, this.tempParty);
        }

        public String toString() {
            return "StartMatchmakingRequest.StartMatchmakingRequestBuilder(extraAttributes=" + this.extraAttributes + ", gameMode=" + this.gameMode + ", id=" + this.id + ", partyAttributes=" + this.partyAttributes + ", priority=" + this.priority + ", tempParty=" + this.tempParty + ")";
        }
    }
}

