/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.lobby.ws_models;

import java.util.HashMap;
import java.util.Map;
import net.accelbyte.sdk.core.util.Helper;

public class UserStatusNotif {
    private String activity;
    private Integer availability;
    private String lastSeenAt;
    private String userId;

    private UserStatusNotif() {
    }

    @Deprecated
    public UserStatusNotif(String activity, Integer availability, String lastSeenAt, String userId) {
        this.activity = activity;
        this.availability = availability;
        this.lastSeenAt = lastSeenAt;
        this.userId = userId;
    }

    public static String getType() {
        return "userStatusNotif";
    }

    public static UserStatusNotif createFromWSM(String message) {
        UserStatusNotif result = new UserStatusNotif();
        Map response = Helper.parseWSM((String)message);
        result.activity = response.get("activity") != null ? (String)response.get("activity") : null;
        result.availability = response.get("availability") != null ? Integer.valueOf((String)response.get("availability")) : null;
        result.lastSeenAt = response.get("lastSeenAt") != null ? (String)response.get("lastSeenAt") : null;
        result.userId = response.get("userId") != null ? (String)response.get("userId") : null;
        return result;
    }

    public String toWSM() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(UserStatusNotif.getType());
        if (this.activity != null) {
            stringBuilder.append("\n").append("activity: ").append(this.activity);
        }
        if (this.availability != null) {
            stringBuilder.append("\n").append("availability: ").append(this.availability);
        }
        if (this.lastSeenAt != null) {
            stringBuilder.append("\n").append("lastSeenAt: ").append(this.lastSeenAt);
        }
        if (this.userId != null) {
            stringBuilder.append("\n").append("userId: ").append(this.userId);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getFieldInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("activity", "activity");
        result.put("availability", "availability");
        result.put("lastSeenAt", "lastSeenAt");
        result.put("userId", "userId");
        return result;
    }

    public static UserStatusNotifBuilder builder() {
        return new UserStatusNotifBuilder();
    }

    public String getActivity() {
        return this.activity;
    }

    public Integer getAvailability() {
        return this.availability;
    }

    public String getLastSeenAt() {
        return this.lastSeenAt;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public void setAvailability(Integer availability) {
        this.availability = availability;
    }

    public void setLastSeenAt(String lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class UserStatusNotifBuilder {
        private String activity;
        private Integer availability;
        private String lastSeenAt;
        private String userId;

        UserStatusNotifBuilder() {
        }

        public UserStatusNotifBuilder activity(String activity) {
            this.activity = activity;
            return this;
        }

        public UserStatusNotifBuilder availability(Integer availability) {
            this.availability = availability;
            return this;
        }

        public UserStatusNotifBuilder lastSeenAt(String lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        public UserStatusNotifBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UserStatusNotif build() {
            return new UserStatusNotif(this.activity, this.availability, this.lastSeenAt, this.userId);
        }

        public String toString() {
            return "UserStatusNotif.UserStatusNotifBuilder(activity=" + this.activity + ", availability=" + this.availability + ", lastSeenAt=" + this.lastSeenAt + ", userId=" + this.userId + ")";
        }
    }
}

